package com.petalslink.easiergov.services;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectNodeImpl;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.resources_api._1.Criteria;
import com.petalslink.resources_api._1.Find;
import com.petalslink.resources_api._1.FindResponse;
import com.petalslink.resources_api._1.Publish;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1.ResourceIdentifier;
import com.petalslink.resources_api._1_0.FindFault;
import com.petalslink.resources_api._1_0.PublishFault;
import com.petalslink.resources_api._1_0.ResourcesManager;
import com.petalslink.services_api._1.Fault;
import com.petalslink.services_api._1.PublishWSDL;
import com.petalslink.services_api._1.PublishWSDLResponse;
import com.petalslink.services_api._1_0.FaultMessage;
import com.petalslink.services_api._1_0.ServicesManager;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTDefinitions;

@javax.jws.WebService(
		serviceName = "ServicesManager",
		portName = "ServicesManagerPort",
		targetNamespace = "http://www.petalslink.com/services-api/1.0",
		wsdlLocation = "services-ws.wsdl",
		endpointInterface = "com.petalslink.services_api._1_0.ServicesManager")
public class ServicesManagerImpl implements ServicesManager {

	private static Logger LOG = Logger.getLogger(ServicesManagerImpl.class.getName());

	
	private ResourcesManager resourceManager;

	public ServicesManagerImpl(ResourcesManager resourceManager) {
		this.resourceManager = resourceManager;
	}

	
	@Override
	public PublishWSDLResponse publishWSDL(PublishWSDL parameters)
			throws FaultMessage {
		PublishWSDLResponse res = new PublishWSDLResponse();
		try {
			Publish request = new Publish();
			request.setRessourceUrl(parameters.getWsdlUrl());
			PublishResponse response = resourceManager.publish(request);
			if(response != null) {
				for(ResourceIdentifier rid: response.getResourceIdentifier()) {
					EJaxbResourceIdentifier rids = new EJaxbResourceIdentifier();
					rids.setId(rid.getId());
					rids.setResourceType(rid.getResourceType());
					res.getResourceIdentifier().add(rids);
				}
			}
		} catch (PublishFault e) {
			FaultMessage businessFault = new FaultMessage();
			FaultMessage faultError = new FaultMessage(e.getMessage(), businessFault);
			if (faultError.getFaultInfo()!= null){
				faultError.getFaultInfo().setMessage(e.getMessage());
			}
			throw faultError;
		}
		return res;
	}

	@Override
	public EJaxbTDefinitions getService(QName idService) throws FaultMessage {
		EJaxbTDefinitions response = null;
		LOG.fine("Call getService method");
		Resource r = ((ResourcesManagerImpl)resourceManager).get(idService, ServiceResourceType.getInstance());
		if(r != null) {
			response = (EJaxbTDefinitions) ((AbstractXmlObjectNodeImpl)r.getContent()).getModelObject();
		} else {
			String errorMsg = "Impossible to find service corresponding to this id: " + idService;
			Fault f = new Fault();
			f.setMessage(errorMsg);
			FaultMessage faultError = new FaultMessage(errorMsg, f);
			throw faultError;
		}
		return response;
	}

	@Override
	public List<EJaxbTDefinitions> findServices(String query) throws FaultMessage {
		List<EJaxbTDefinitions> response = new ArrayList<EJaxbTDefinitions>();
		LOG.fine("Call findServices method");
		try {
			Criteria c = new Criteria();
			c.setName("resource-type");
			c.setValue(ServiceResourceType.getInstance().getTypeName());
			Find f = new Find();
			f.setQuery(query);
			f.getCriteria().add(c);
			FindResponse fr = resourceManager.find(f);
			for(Object obj: fr.getAny()) {
				response.add((EJaxbTDefinitions)obj);
			}
		} catch (FindFault e) {
			FaultMessage businessFault = new FaultMessage();
			FaultMessage faultError = new FaultMessage(e.getMessage(), businessFault);
			if (faultError.getFaultInfo()!= null){
				faultError.getFaultInfo().setMessage(e.getMessage());
			}
			throw faultError;
		}
		return response;
	}

	@Override
	public EJaxbTDefinitions getEndpoint(QName idEndpoint) throws FaultMessage {
		EJaxbTDefinitions response = null;
		LOG.fine("Call getEndpoint method");
		Resource r = ((ResourcesManagerImpl)resourceManager).get(idEndpoint, EndpointResourceType.getInstance());
		if(r != null) {
			response = (EJaxbTDefinitions) ((AbstractXmlObjectNodeImpl)r.getContent()).getModelObject();
		} else {
			String errorMsg = "Impossible to find endpoint corresponding to this id: " + idEndpoint;
			Fault f = new Fault();
			f.setMessage(errorMsg);
			FaultMessage faultError = new FaultMessage(errorMsg, f);
			throw faultError;
		}
		return response;
	}

	@Override
	public List<EJaxbTDefinitions> findEndpoints(String query)
			throws FaultMessage {
		List<EJaxbTDefinitions> response = new ArrayList<EJaxbTDefinitions>();
		LOG.fine("Call findEndpoints method");
		try {
			Criteria c = new Criteria();
			c.setName("resource-type");
			c.setValue(EndpointResourceType.getInstance().getTypeName());
			Find f = new Find();
			f.setQuery(query);
			f.getCriteria().add(c);
			FindResponse fr = resourceManager.find(f);
			for(Object obj: fr.getAny()) {
				response.add((EJaxbTDefinitions)obj);
			}
		} catch (FindFault e) {
			FaultMessage businessFault = new FaultMessage();
			FaultMessage faultError = new FaultMessage(e.getMessage(), businessFault);
			if (faultError.getFaultInfo()!= null){
				faultError.getFaultInfo().setMessage(e.getMessage());
			}
			throw faultError;
		}
		return response;
	}

	@Override
	public EJaxbTDefinitions getInterface(QName idInterface)
			throws FaultMessage {
		EJaxbTDefinitions response = null;
		LOG.fine("Call getInterface method");
		Resource r = ((ResourcesManagerImpl)resourceManager).get(idInterface, InterfaceResourceType.getInstance());
		if(r != null) {
			response = (EJaxbTDefinitions) ((AbstractXmlObjectNodeImpl)r.getContent()).getModelObject();
		} else {
			String errorMsg = "Impossible to find interface corresponding to this id: " + idInterface;
			Fault f = new Fault();
			f.setMessage(errorMsg);
			FaultMessage faultError = new FaultMessage(errorMsg, f);
			throw faultError;
		}
		return response;
	}
	
	@Override
	public List<EJaxbTDefinitions> findInterfaces(String query)
			throws FaultMessage {
		List<EJaxbTDefinitions> response = new ArrayList<EJaxbTDefinitions>();
		LOG.fine("Call findInterfaces method");
		try {
			Criteria c = new Criteria();
			c.setName("resource-type");
			c.setValue(InterfaceResourceType.getInstance().getTypeName());
			Find f = new Find();
			f.setQuery(query);
			f.getCriteria().add(c);
			FindResponse fr = resourceManager.find(f);
			for(Object obj: fr.getAny()) {
				response.add((EJaxbTDefinitions)obj);
			}
		} catch (FindFault e) {
			FaultMessage businessFault = new FaultMessage();
			FaultMessage faultError = new FaultMessage(e.getMessage(), businessFault);
			if (faultError.getFaultInfo()!= null){
				faultError.getFaultInfo().setMessage(e.getMessage());
			}
			throw faultError;
		}
		return response;
	}

}
