/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiergov.cli.impl.command;

import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.petalslink.data_api._1.PublishSchemaFromURL;
import com.petalslink.data_api._1.PublishSchemaFromURLResponse;
import java.io.File;
import java.util.List;

public class PublishSchemaFromUrlCommand
extends AbstractCommand<DataManagerClientImplSOAP> {
    private String url;

    public PublishSchemaFromUrlCommand(DataManagerClientImplSOAP client) throws ESBException {
        super((Object)client);
        this.setName("PublishSchema");
        this.setDescription("Publish Schema From Url");
        this.setShortcut("psc");
    }

    public void execute() {
        try {
            PublishSchemaFromURL request = new PublishSchemaFromURL();
            if (this.url.startsWith(".")) {
                this.url = "file:///" + new File(this.url).getAbsolutePath();
            }
            request.setXsdUrl(this.url);
            PublishSchemaFromURLResponse res = ((DataManagerClientImplSOAP)this.getClient()).publishSchemaFromURL(request);
            this.setResult("Schema is loaded: " + this.url);
            this.resultCode = 1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
    }

    protected int doProcess(List<String> args) {
        this.url = args.get(0);
        this.execute();
        return this.resultCode;
    }

    protected boolean validateArgs(List<String> args) {
        return args.size() == 1;
    }

    public String toString() {
        return "psc <url> \t\t\t\t\t\t{Publish Schema From Url}";
    }
}

