/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.api.model.generic;

import java.util.Set;

import javax.xml.namespace.QName;

import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface GenericElement<E extends GenericElement<E>> extends SemanticPart {

	/**
	 * Get list of child semantic elements
	 * 
	 * @return list of child elements
	 */
	public Set<E> getChildElements();
	
	/**
	 * Add child element
	 * 
	 * @param child SemanticElement
	 */
	public void addChildElement(E child);
	
	/**
	 * Set child elements
	 * 
	 * @param children SemanticElement
	 */
	public void setChildElements(Set<E> children);
	
	/**
	 * Remove semantic element from child list
	 * 
	 * @param child SemanticElement
	 */
	public void removeChildElement(E child);
	
	/**
	 * Is there any child element
	 * 
	 * @return boolean
	 */
	public boolean hasChildElement();
	
	/**
	 * Is this semantic element required or optional ?
	 * 
	 * @return boolean	 
	 */
	public boolean isRequired();

	/**
	 * Set the semantic element required or not.
	 * 
	 * @param required	Is this semantic element required or optional ?	 
	 */
	public void setRequired(boolean required);
	
	/**
	 * Get the syntactic element QName
	 * 
	 * @return related element as QName
	 */
	public QName getElementQName();
	
	/**
	 * Set element QName
	 * 
	 * @param related element QName
	 */
	public void setElementQName(QName elementQName);
	
}
