/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.api.model.generic;

import java.util.Set;

import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface GenericProfile<P extends GenericPart, E extends GenericElement<E>> {
	
	public Set<Operation> getOperations(); 
	
	public void addOperation(Operation operation);
	
	public void removeOperation(Operation operation);
	
	
	public Partner getPartner();
	
	public boolean hasPartner();
	
	public void setPartner(Partner partner);
	
	
	public P getSemanticInterface();
	
	public void setSemanticInterface(P semanticInterface);
	
	
	public P getSemanticOperation();
	
	public void setSemanticOperation(P semanticOperation);
	
	
	public E getInputSemanticElement();
	
	public void setInputSemanticElement(E semanticElement);
	
	
	public E getOutputSemanticElement();
	
	public void setOutputSemanticElement(E semanticElement);

	
}
