/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.impl.model.generic;

import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;

import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericProfile;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public abstract class GenericProfileImpl<P extends GenericPart, E extends GenericElement<E>> implements GenericProfile<P, E> {

	protected E semanticInput = null;
	protected E semanticOutput = null;
	protected P semanticOperation = null;
	protected P semanticInterface = null;
	
	protected QName operationQName = null;
	protected Set<QName> serviceQNames = new HashSet<QName>();
	
	protected Partner partner = null;

	public E getInputSemanticElement() {
		return semanticInput;
	}

	public E getOutputSemanticElement() {
		return semanticOutput;
	}

	public P getSemanticInterface() {
		return semanticInterface;
	}

	public P getSemanticOperation() {
		return semanticOperation;
	}

	public void setInputSemanticElement(E input) {
		this.semanticInput = input;
	}

	public void setOutputSemanticElement(E output) {
		this.semanticOutput = output;
	}
	
	public void setSemanticInterface(P semanticInterface) {
		this.semanticInterface = semanticInterface;		
	}

	public void setSemanticOperation(P semanticOperation) {
		this.semanticOperation = semanticOperation;
	}

	public QName getOperationQName() {
		return operationQName;
	}

	public void setOperationQName(QName operationQName) {
		this.operationQName = operationQName;
	}

	public Set<QName> getServiceQNames() {
		return serviceQNames;
	}

	public void addServiceQName(QName serviceQName) {
		this.serviceQNames.add(serviceQName);
	}
	
	public void removeServiceQName(QName serviceQName) {
		this.serviceQNames.remove(serviceQName);
	}
	
	/**
	 * @return the partner
	 */
	public Partner getPartner() {
		return partner;
	}
	
	public boolean hasPartner() {
		return partner != null;
	}

	/**
	 * @param partner the partner to set
	 */
	public void setPartner(Partner partner) {
		this.partner = partner;
	}

	@Override
	public boolean equals(Object other) {
		if(other instanceof GenericProfile<?,?>){
			return this.operationQName.equals(((GenericProfile<?,?>)other).getOperationQName());
		}else{
			return false;
		}
	}
	
	@Override
	public int hashCode() {
		return this.operationQName.hashCode();
	}
	
	@Override
	public String toString(){
		StringBuilder str = new StringBuilder();
		if(semanticOperation != null){
			str.append("\n\tOperation: " + semanticOperation.toString());
		}
		if(semanticInterface != null){
			str.append("\n\tInterface: " + semanticInterface.toString());
		}
		if(semanticInput != null){
			str.append("\n\tInput: " + semanticInput.toString());
		}
		if(semanticOutput != null){
			str.append("\n\tOutput: " + semanticOutput.toString());
		}
		return str.toString();
	}

}