/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.impl.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.registry.SemanticProfileRegistry;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SemanticProfileRegistryImpl implements SemanticProfileRegistry {

	Map<QName, SemanticProfile> registry = new HashMap<QName, SemanticProfile>();
	
	Map<Partner, Set<SemanticProfile>> partnerProfiles = new HashMap<Partner, Set<SemanticProfile>>();
	
	public SemanticProfileRegistryImpl(){
		
	}
	
	public void addSemanticProfile(SemanticProfile profile) {
		registry.put(profile.getOperationQName(), profile);
		if(profile.hasPartner()){
			Partner partner = profile.getPartner();
			if(partnerProfiles.containsKey(partner)){
				partnerProfiles.get(partner).add(profile);
			} else {
				Set<SemanticProfile> profiles = new HashSet<SemanticProfile>();
				profiles.add(profile);
				partnerProfiles.put(partner, profiles);
			}
		}
	}

	public void removeSemanticProfile(QName operationQName) {
		SemanticProfile profile = registry.get(operationQName);
		if(profile != null){
			registry.remove(operationQName);
			if(profile.hasPartner()){
				Partner partner = profile.getPartner();
				Set<SemanticProfile> profiles = partnerProfiles.get(partner);
				profiles.remove(profile);
				if(profiles.isEmpty()){
					partnerProfiles.remove(partner);
				}
			}
		}
	}

	public SemanticProfile getSemanticProfile(QName operationQName) {
		return registry.get(operationQName);
	}
	
	public Set<SemanticProfile> getAllSemanticProfiles(){
		return new HashSet<SemanticProfile>(registry.values());
	}

	public Set<SemanticProfile> findSemanticProfilesByPartner(Partner partner) {
		return partnerProfiles.get(partner);
	}

	public void removeAllSemanticProfiles() {
		registry.clear();
		partnerProfiles.clear();
	}

	public void removeSemanticProfilesByPartner(Partner partner) {
		Set<SemanticProfile> tempProfiles = findSemanticProfilesByPartner(partner);
		for(SemanticProfile profile : tempProfiles){
			registry.remove(profile.getOperationQName());
		}
		partnerProfiles.remove(partner);
	}

}
