/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.impl;

import java.net.URI;
import java.util.Set;

import com.petalslink.easiersbs.registry.service.api.SemanticRegistryFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.impl.model.PartnerImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticElementImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticPartImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticProfileImpl;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SemanticRegistryFactoryImpl implements SemanticRegistryFactory {

	private static SemanticRegistryManager manager = new SemanticRegistryManagerImpl();
	
	private static SemanticRegistryFactory instance = new SemanticRegistryFactoryImpl();
	
	private SemanticRegistryFactoryImpl(){
		
	}
	
	public static SemanticRegistryFactory getInstance(){
		return instance;
	}
	
	public SemanticRegistryManager getSemanticRegistryManager() {
		return manager;
	}

	public SemanticProfile newSemanticProfile() {
		return new SemanticProfileImpl();
	}

	public SemanticPart newSemanticPart() {
		return new SemanticPartImpl();
	}

	public SemanticPart newSemanticPart(Set<URI> concepts) {
		return new SemanticPartImpl(concepts);
	}
	
	public SemanticElement newSemanticElement() {
		return new SemanticElementImpl();
	}

	public Partner newPartner(String name) {
		return new PartnerImpl(name);
	}

}