/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.impl.model.generic;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;

import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public abstract class GenericPartImpl implements GenericPart {

	
	protected Set<URI> concepts = new HashSet<URI>();
	
	protected String name = "";
	
	
	public void addSemanticConcept(URI concept) {
			concepts.add(concept);
	}

	public Set<URI> getSemanticConcepts() {
		return concepts;
	}
	
	public void setSemanticConcepts(Set<URI> concepts) {
		this.concepts = concepts;
	}

	public void removeSemanticConcept(URI concept) {
		concepts.remove(concept);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	
	@Override
	public boolean equals(Object other) {
		if(other instanceof GenericPart && name != null){
			return this.name.equals(((GenericPart) other).getName()) 
					&& this.concepts.equals(((GenericPart)other).getSemanticConcepts());
		} else {
			return false;
		}
	}
	
	@Override
	public int hashCode() {
		return this.name.hashCode();
	}
	
	@Override
	public String toString(){
		return name + ": " + concepts.toString();
	}
	
}
