/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.api;

import java.net.URI;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.profile.Element;
import com.petalslink.easiersbs.matching.service.api.profile.Part;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface ProfileFactory {

	
	/**
	 * Create a new empty simple search profile
	 * 
	 * @return new simple search profile
	 */
	public SearchProfile newSearchProfile();
	
	/**
	 * Create a new simple search profile with initial values
	 * 
	 * @param semanticInterface		SemanticPart containing expected interface concepts
	 * @param semanticOperation		SemanticPart containing expected operation concepts
	 * @param semanticInput			Set of SemanticElements corresponding to Input expected elements
	 * @param semanticOutput		Set of SemanticElements corresponding to Output expected elements
	 * @param semanticFault			Set of SemanticElements corresponding to Fault expected elements
	 * @return new simple search profile
	 */
	public SearchProfile newSearchProfile(Part semanticInterface, 
										  Part semanticOperation, 
										  Set<Element> semanticInput, 
										  Set<Element> semanticOutput);
	
	/**
	 * Create a new search profile from an existing semantic profile
	 * 
	 * @param profile 				SemanticProfile corresponding to expected search profile 
	 * @return new simple search profile
	 */
	public SearchProfile newSearchProfile(SemanticProfile profile);
	
	/**
	 * Create a new empty semantic part
	 * 
	 * @return new semantic part 
	 */
	public Part newSemanticPart();
	
	/**
	 * Create a new semantic part with initial value
	 * 
	 * @param semanticConcepts		Set of semantic concepts
	 * @return new semantic part 
	 */
	public Part newSemanticPart(Set<URI> semanticConcepts);
	
	/**
	 * Create a new empty semantic element
	 * 
	 * @return new semantic element 
	 */
	public Element newSemanticElement();
	
	/**
	 * Create a new semantic element with initial value
	 * 
	 * @param semanticConcepts		Set of semantic concepts
	 * @param isRequired			Is this element required (true) or optional (false)
	 * @return new semantic part 
	 */
	public Element newSemanticElement(Set<URI> semanticConcepts, boolean isRequired);
	
	public Partner newPartner(String name);

}
