/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */  
package com.petalslink.easiersbs.matching.service.api.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityType;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface MatcherProperties {

	// General matching properties
	public final static String OPERATION_WEIGHT = "easiersbs.general.operation.weight";

	// Hybrid matcher properties
	public final static String SEMANTIC_WEIGHT = "easiersbs.hybrid.semantic.weight";
	
	// Semantic properties
	public final static String SEMANTIC_ACCEPTANCE_THRESHOLD = "easiersbs.semantic.acceptance.threshold";
	public final static String EQUIVALENT_CONCEPT_MARK = "easiersbs.semantic.equivalent.concept.mark";
	public final static String SPECIALIZATION_CONCEPT_MARK = "easiersbs.semantic.specialization.concept.mark";
	public final static String GENERALIZATION_CONCEPT_MARK = "easiersbs.semantic.generalization.concept.mark";
	public final static String EXACT_MARK = "easiersbs.semantic.exact.mark";
	public final static String PLUGIN_MARK = "easiersbs.semantic.plugin.mark";
	public final static String SUBSUME_MARK = "easiersbs.semantic.subsume.mark";
	
	// Syntactic properties
	public final static String SYNTACTIC_ACCEPTANCE_THRESHOLD = "easiersbs.syntactic.acceptance.threshold";
	public final static String LEVENSHTEIN_LIMIT = "easiersbs.syntactic.levenshtein.limit";
	public final static String SIMILARITY_TYPE = "easiersbs.syntactic.similarity.type";
	
	
	double getOperationWeight();
	
	double getInputOutputWeigth();
	
	void setOperationWeight(double weight);
	
	double getSemanticWeight();
	
	double getSyntacticWeigth();
	
	void setSemanticWeight(double weight);
	
	double getSemanticThreshold();
	
	void setSemanticThreshold(double threshold);
	
	double getSyntacticThreshold();
	
	void setSyntacticThreshold(double threshold);
	
	double getExactMark();
	
	void setExactMark(double mark);
	
	double getPluginMark();
	
	void setPluginMark(double mark);
	
	double getSubsumeMark();
	
	void setSubsumeMark(double mark);
	
	double getEquivalentMark();
	
	void setEquivalentMark(double mark);
	
	double getSpecializationMark();
	
	void setSpecializationMark(double mark);
	
	double getGeneralizationMark();
	
	void setGeneralizationMark(double mark);
	
	int getLevenshteinLimit();
	
	void setLevenshteinLimit(int limit);
	
	SimilarityType getSimilarityType();
	
	void setSimilarityType(SimilarityType type);
	
}
