/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.api.profile.infered;

import java.net.URI;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface RatedURI extends Comparable<RatedURI> {
	
	
	/**
	 * Get the associated rate of the QName (which correspond to the semantic proximity to the initial concept)
	 * This rate is given between 0 and 1.
	 * 
	 * @return rate	Semantic concept rate
	 */
	public double getRate();
	
	/**
	 * Set the associated rate of the semantic concept (semantic proximity compared to initial concept)
	 * This rate ranges from 0 to 1. All value higher than 1 is reduced to this maximum.
	 * 1 means this concept is identical to the initial one and 0 totally different.
	 * 
	 * @param rate	Semantic concept rate, double between 0 and 1
	 */
	public void setRate(double rate);
	
	public URI getConcept();
	
	public void setConcept(URI concept);

	/**
	 * @return String containing classical information about QName and its associated rate
	 */
	public String toString();

}