/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile.infered;

import java.util.HashSet;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedPart;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSemanticConcept;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class InferedSemanticPartImpl implements InferedPart {

	private Set<InferedSemanticConcept> semanticConcepts = new HashSet<InferedSemanticConcept>();
	
	public InferedSemanticPartImpl(){
		
	}
	
	public InferedSemanticPartImpl(Set<InferedSemanticConcept> semanticConcepts){
		this.semanticConcepts = semanticConcepts;
	}
	
	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticPart#addInferedSemanticConcept(com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticConcept)
	 */
	@Override
	public void addInferedSemanticConcept(InferedSemanticConcept semanticConcept) {
		semanticConcepts.add(semanticConcept);
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticPart#getInferedSemanticConcepts()
	 */
	@Override
	public Set<InferedSemanticConcept> getInferedSemanticConcepts() {
		return semanticConcepts;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticPart#removeInferedSemanticConcept(com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticConcept)
	 */
	@Override
	public void removeInferedSemanticConcept(InferedSemanticConcept semanticConcept) {
		semanticConcepts.remove(semanticConcept);
	}
	
	@Override
	public String toString(){
		return semanticConcepts.toString();
	}
	
	
}