/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.HybridMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.Set;

public class HybridMatcherImpl
extends AbstractMatcherImpl
implements HybridMatcher {
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private SemanticMatcher semanticMatcher;
    private SyntacticMatcher syntacticMatcher;
    private MatcherProperties props;

    public HybridMatcherImpl(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager, MatcherProperties matcherProperties) throws ReasonerException, EasierSBSException {
        this.props = matcherProperties;
        this.registry = semanticRegistryManager;
        this.semanticMatcher = this.factory.newSemanticMatcher(reasonerFactory, semanticRegistryManager, matcherProperties);
        this.syntacticMatcher = this.factory.newSyntacticMatcher(semanticRegistryManager, matcherProperties);
    }

    public HybridMatcherImpl(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager) throws ReasonerException, EasierSBSException {
        this(reasonerFactory, semanticRegistryManager, new MatcherPropertiesImpl());
    }

    public SyntacticMatcher getSyntacticMatcher() {
        return this.syntacticMatcher;
    }

    public SemanticMatcher getSemanticMatcher() {
        return this.semanticMatcher;
    }

    @Override
    public MatchingResult findServices(SearchProfile searchProfile, Set<SemanticProfile> set) {
        MatchingResultImpl matchingResultImpl = new MatchingResultImpl(searchProfile);
        MatchingResult matchingResult = this.semanticMatcher.findServices(searchProfile, set);
        MatchingResult matchingResult2 = this.syntacticMatcher.findServices(searchProfile, matchingResult.getResultProfiles().keySet());
        for (SemanticProfile semanticProfile : matchingResult.getResultProfiles().keySet()) {
            double d = (Double)matchingResult.getResultProfiles().get(semanticProfile) * this.props.getSemanticWeight();
            if (matchingResult2.getResultProfiles().containsKey(semanticProfile)) {
                d += (Double)matchingResult2.getResultProfiles().get(semanticProfile) * this.props.getSyntacticWeigth();
            }
            matchingResultImpl.addResultProfile(semanticProfile, d);
        }
        return matchingResultImpl;
    }
}

