/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.profile;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.Element;
import com.petalslink.easiersbs.matching.service.api.profile.Part;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSearchProfile;
import com.petalslink.easiersbs.matching.service.profile.ElementImpl;
import com.petalslink.easiersbs.matching.service.profile.PartImpl;
import com.petalslink.easiersbs.matching.service.profile.infered.InferedSearchProfileImpl;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.HashSet;
import java.util.Set;

public class SearchProfileImpl
implements SearchProfile {
    private Set<Element> semanticInputs = new HashSet<Element>();
    private Set<Element> semanticOutputs = new HashSet<Element>();
    private Part semanticOperation = null;
    private Part semanticInterface = null;

    public SearchProfileImpl() {
    }

    public SearchProfileImpl(SemanticProfile semanticProfile) {
        this.semanticInterface = new PartImpl(semanticProfile.getSemanticInterface());
        this.semanticOperation = new PartImpl(semanticProfile.getSemanticOperation());
        for (SemanticElement semanticElement : semanticProfile.getInputSemanticElements()) {
            this.semanticInputs.add(new ElementImpl(semanticElement));
        }
        for (SemanticElement semanticElement : semanticProfile.getOutputSemanticElements()) {
            this.semanticOutputs.add(new ElementImpl(semanticElement));
        }
    }

    public SearchProfileImpl(Part part, Part part2, Set<Element> set, Set<Element> set2) {
        this.semanticInterface = part;
        this.semanticOperation = part2;
        if (set != null) {
            this.semanticInputs = set;
        }
        if (set2 != null) {
            this.semanticOutputs = set2;
        }
    }

    public void addInputSemanticElement(Element element) {
        this.semanticInputs.add(element);
    }

    public void addOutputSemanticElement(Element element) {
        this.semanticOutputs.add(element);
    }

    public Set<Element> getInputSemanticElements() {
        return this.semanticInputs;
    }

    public Set<Element> getOutputSemanticElements() {
        return this.semanticOutputs;
    }

    public Part getSemanticInterface() {
        return this.semanticInterface;
    }

    public Part getSemanticOperation() {
        return this.semanticOperation;
    }

    public void removeInputSemanticElement(Element element) {
        this.semanticInputs.remove(element);
    }

    public void removeOutputSemanticElement(Element element) {
        this.semanticOutputs.remove(element);
    }

    public void setSemanticInterface(Part part) {
        this.semanticInterface = part;
    }

    public void setSemanticOperation(Part part) {
        this.semanticOperation = part;
    }

    public InferedSearchProfile infer(Reasoner reasoner, MatcherProperties matcherProperties) {
        InferedSearchProfileImpl inferedSearchProfileImpl = new InferedSearchProfileImpl();
        inferedSearchProfileImpl.setSemanticInterface(this.semanticInterface.infer(reasoner, matcherProperties));
        inferedSearchProfileImpl.setSemanticOperation(this.semanticOperation.infer(reasoner, matcherProperties));
        for (Element element : this.semanticInputs) {
            inferedSearchProfileImpl.addInputSemanticElement(element.infer(reasoner, matcherProperties));
        }
        for (Element element : this.semanticOutputs) {
            inferedSearchProfileImpl.addOutputSemanticElement(element.infer(reasoner, matcherProperties));
        }
        return inferedSearchProfileImpl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("++++++++++++++++++++++");
        stringBuilder.append("\nSearchProfile:");
        stringBuilder.append("\n\tOperation: " + this.semanticOperation.toString());
        stringBuilder.append("\n\tInterface: " + this.semanticOperation.toString());
        stringBuilder.append("\n\tInput(s): ");
        for (Element element : this.semanticInputs) {
            stringBuilder.append("\n\t\t" + element.toString());
        }
        stringBuilder.append("\n\tOutput(s): ");
        for (Element element : this.semanticOutputs) {
            stringBuilder.append("\n\t\t" + element.toString());
        }
        stringBuilder.append("\n++++++++++++++++++++++");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof SearchProfile) {
            return !(this.semanticInterface != null && !this.semanticInterface.equals(((SearchProfile)object).getSemanticInterface()) || this.semanticOperation != null && !this.semanticOperation.equals(((SearchProfile)object).getSemanticOperation()) || !((Object)this.semanticInputs).equals(((SearchProfile)object).getInputSemanticElements())) && ((Object)this.semanticOutputs).equals(((SearchProfile)object).getOutputSemanticElements());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

