/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.similarity;

import com.petalslink.easiersbs.matching.service.matcher.similarity.AbstractSimilarityMeasureImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DoubleVector;
import java.util.List;
import java.util.Map;

public class JensenShannonSimilarityImpl
extends AbstractSimilarityMeasureImpl {
    public JensenShannonSimilarityImpl() {
    }

    public JensenShannonSimilarityImpl(int n) {
        super.setLevenshteinLimit(n);
    }

    public double measureSimilarity(List<String> list, List<String> list2) {
        if (list.isEmpty() || list2.isEmpty()) {
            return 0.0;
        }
        Map<String, Integer> map = this.countWordFrequency(list);
        Map<String, Integer> map2 = this.countWordFrequency(list2);
        DoubleVector doubleVector = this.getProperVectors(map, map2);
        double[] dArray = new double[doubleVector.length()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (double)(doubleVector.getVector1()[i] + doubleVector.getVector2()[i]) / 2.0;
        }
        double d = (this.kullbackLieblerDivergence(doubleVector.getVector1(), dArray) + this.kullbackLieblerDivergence(doubleVector.getVector2(), dArray)) / 2.0;
        if ((d = 1.0 - d / 3.4) < 0.0) {
            d = 0.0;
        }
        logger.finest("Jensen-Shannon similarity fully measured: " + d);
        return d;
    }

    private double kullbackLieblerDivergence(int[] nArray, double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0 || dArray[i] == 0.0) continue;
            d += (double)nArray[i] * Math.log(nArray[i]) - (double)nArray[i] * Math.log(dArray[i]);
        }
        return d;
    }
}

