/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.profile.inferred.InferredElementImpl;
import com.petalslink.easiersbs.matching.service.util.ProfileUtil;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.impl.model.generic.GenericElementImpl;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SearchElementImpl extends GenericElementImpl<SearchElement> implements SearchElement {

	public SearchElementImpl(){
		
	}
	
	public SearchElementImpl(String name, Set<URI> concepts, boolean required){
		this.name = name;
		this.concepts = concepts;
		this.required = required;
	}
	
	public InferredElement infer(Reasoner reasoner, MatcherProperties props) {
		return inferHierarchy(this, new HashSet<SearchElement>(), reasoner, props);
	}
	
	private InferredElement inferHierarchy(SearchElement elem, Set<SearchElement> elementList, Reasoner reasoner, MatcherProperties props){
		InferredElement inferredElem = new InferredElementImpl(this);
		// Managing semantic concepts
		for(URI concept : elem.getSemanticConcepts()){
			inferredElem.addInferedSemanticConcept(ProfileUtil.inferConcept(concept, reasoner, props));
		}
		inferredElem.setElementQName(elem.getElementQName());
		inferredElem.setName(elem.getName());
		inferredElem.setRequired(elem.isRequired());
		elementList.add(elem);
		// Managing element children
		for(SearchElement child : elem.getChildElements()){
			if( ! elementList.contains(child)){
				inferredElem.addChildElement(inferHierarchy(child, elementList, reasoner, props));
			}
		}
		return inferredElem;
	}
		
}