/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.util;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class VectorUtil {

	
    public static double magnitude(int[] vector) {        
        return Math.sqrt(dotProduct(vector,vector));
    }
    
    public static int dotProduct(int[] vector1, int[] vector2) {
        if (vector1.length != vector2.length){
        	return 0;
        }
            
        int res = 0;
        for (int i = 0 ; i < vector1.length ; i++){
        	res += vector1[i] * vector2[i];
        }
            
        return res;
    }
    
    public static double[] normalize(int[] vector){
    	double[] res = new double[vector.length];
    	double length = magnitude(vector);
    	for(int i = 0 ; i < vector.length ; i++){
    		res[i] = vector[i] / length;
    	}    	
    	return res;
    }
    
    public static double average(Double[] vector){
    	if(vector.length == 0) return 0.0;
    	
    	double sum = 0.0;
    	for(double d : vector){
    		sum += d;
    	}
    	return sum / vector.length;
    }
    
    public static int max(Integer[] vector) {
    	int res = 0;
    	for(Integer i : vector){
    		res = Math.max(i, res);
    	}
        return res;
    }

}
