/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.matcher;

import java.util.Set;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;

import com.petalslink.easiersbs.matching.service.api.matcher.Matcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.profile.SearchProfileImpl;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public abstract class AbstractMatcherImpl implements Matcher {

	protected SemanticRegistryManager registry;
	protected MatcherProperties props;
	
	public MatcherProperties getMatcherProperties() {
		return props;
	}
	
	public void setMatcherProperties(MatcherProperties props) {
		this.props = props;
	}

	public SemanticRegistryManager getSemanticRegistryManager() {
		return registry;
	}

	public MatchingResult findServices(SearchProfile profile) {
		return this.findServices(profile, registry.getAllSemanticProfiles());
	}
	
	public MatchingResult findServices(SearchProfile profile, Partner partner) {
		return this.findServices(profile, registry.findSemanticProfilesByPartner(partner));
	}

	public MatchingResult findServices(QName operationQName, Description sawsdlDesc) {
		SemanticProfile profile = ServiceUtil.extractSemanticProfile(operationQName, sawsdlDesc);
		return this.findServices(new SearchProfileImpl(profile));
	}
	
	public MatchingResult findServices(QName operationQName, Description sawsdlDesc, Partner partner) {
		SemanticProfile profile = ServiceUtil.extractSemanticProfile(operationQName, sawsdlDesc);
		return this.findServices(new SearchProfileImpl(profile), partner);
	}
	
	public abstract MatchingResult findServices(SearchProfile profile, Set<SemanticProfile> serviceList);
}
