/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.matcher.similarity;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class DoubleVector {

	private int[] vector1;
	private int[] vector2;
	private int length;
	
	public DoubleVector(int[] vector1, int[] vector2){
		this.vector1 = vector1;
		this.vector2 = vector2;
		this.length = Math.max(vector1.length, vector2.length);
	}

	public int length() {
		return length;
	}
	
	/**
	 * @return the first vector
	 */
	public int[] getVector1() {
		return vector1;
	}

	/**
	 * @return the second vector
	 */
	public int[] getVector2() {
		return vector2;
	}
	
}
