/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile.inferred;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;

import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredConcept;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.RatedURI;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class InferredConceptImpl implements InferredConcept {

	private Set<RatedURI> ratedSemanticConcepts = new HashSet<RatedURI>();
	
	public InferredConceptImpl(){
		
	}
	
	public InferredConceptImpl(SortedSet<RatedURI> ratedSemanticConcepts){
		this.ratedSemanticConcepts = ratedSemanticConcepts;
	}
	
	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticConcept#addRatedSemanticConcept(com.petalslink.easiersbs.matching.service.api.profile.RatedSemanticConcept)
	 */
	@Override
	public void addRatedSemanticConcept(RatedURI ratedConcept) {
		if(ratedSemanticConcepts.contains(ratedConcept)){
			Iterator<RatedURI> it = ratedSemanticConcepts.iterator();
			while(it.hasNext()){
				RatedURI concept = it.next();
				if(ratedConcept.equals(concept)){
					concept.setRate(Math.max(concept.getRate(), ratedConcept.getRate()));
					break;
				}
			}
		} else {
			ratedSemanticConcepts.add(ratedConcept);
		}
	}
	
	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticConcept#getRatedSemanticConcepts()
	 */
	@Override
	public Set<RatedURI> getRatedSemanticConcepts() {
		return ratedSemanticConcepts;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticConcept#removeRatedSemanticConcept(com.petalslink.easiersbs.matching.service.api.profile.RatedSemanticConcept)
	 */
	@Override
	public void removeRatedSemanticConcept(RatedURI ratedConcept) {
		ratedSemanticConcepts.remove(ratedConcept);
	}
	
	@Override
	public String toString(){
		StringBuilder str = new StringBuilder();
		for(RatedURI concept : ratedSemanticConcepts){
			str.append(concept.toString()+ ", ");
		}
		return "[" + str.toString() + "]";
	}
	
}