/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.matcher;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class MatchingResultImpl implements MatchingResult {

	
	private SortedSet<RatedSemanticProfile> profiles = new TreeSet<RatedSemanticProfile>();
	
	private SearchProfile query;
	
	public MatchingResultImpl(SearchProfile query){
		this.query = query;
	}

	/**
	 * @return the query
	 */
	public SearchProfile getQuery() {
		return query;
	}

	public SortedSet<RatedSemanticProfile> getResultProfiles() {
		return profiles;
	}

	public void addResultProfile(RatedSemanticProfile profile) {
		profiles.add(profile);
	}

	public void removeResultProfile(RatedSemanticProfile profile) {
		profiles.remove(profile);
	}

	public boolean hasExactProfile() {
		if(profiles.first() != null) {
			return (profiles.first().getProfileRate() == 1.0);
		} else {
			return false;
		}
	}

	public boolean hasCorrectProfile(double acceptanceThreshold) {
		if(profiles.first() != null
			&& profiles.first().getProfileRate() > acceptanceThreshold) {
			return true;
		} else {
			return false;
		}
	}
	
	public SortedSet<RatedSemanticProfile> getCorrectProfiles(double acceptanceThreshold) {
		SortedSet<RatedSemanticProfile> res = new TreeSet<RatedSemanticProfile>();
		for(RatedSemanticProfile profile : profiles) {
			if(profile.getProfileRate() >= acceptanceThreshold){
				res.add(profile);
			}
		}
		return res;
	}

	public RatedSemanticProfile getBestProfile() {
		try{
			return profiles.first();
		} catch (NoSuchElementException e){
			return null;
		}
	}

	@Override
	public SortedSet<RatedSemanticProfile> getTopKProfiles(int k) {
		SortedSet<RatedSemanticProfile> res = new TreeSet<RatedSemanticProfile>();
		Iterator<RatedSemanticProfile> it = profiles.iterator();
		while(it.hasNext()
				&& res.size() < k){
			res.add(it.next());
		}
		return res;
	}

	@Override
	public RatedSemanticProfile findProfile(SemanticProfile profile) {
		for(RatedSemanticProfile rated : profiles){
			if(rated.getProfile().equals(profile)){
				return rated;
			}
		}
		return null;
	}
	
	@Override
	public String toString(){
		StringBuilder str = new StringBuilder();
		str.append("MatchingResult for " + query.getOperations());
		for(RatedSemanticProfile profile : profiles) {
			str.append("\n" + profile.toString());
		}
		return str.toString();
	}

}
