package com.petalslink.easiersbs.matching.service.matcher.computation;

import java.util.List;
import java.util.concurrent.Callable;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticProfileImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;

public class SyntacticComputationImpl implements Callable<RatedSemanticProfile> {

	private MatcherProperties props;
	private SimilarityMeasure similarity;
	private List<String> functionalWords;
	private List<String> inputWords;
	private List<String> outputWords;
	private SemanticProfile service;

	
	public SyntacticComputationImpl(MatcherProperties props, SimilarityMeasure similarity,
							List<String> functionalWords, List<String> inputWords, 
							List<String> outputWords, SemanticProfile targetService){
		this.props = props;
		this.similarity = similarity;
		this.functionalWords = functionalWords;
		this.inputWords = inputWords;
		this.outputWords = outputWords;
		this.service = targetService;
	}
	
	@Override
	public RatedSemanticProfile call() throws Exception {
		RatedSemanticProfile res = new RatedSemanticProfileImpl(service);
		
		Double funcRate = null;
		Double ioRate = null;
		
		if(props.getOperationWeight() != 0.0){
			List<String> serviceFunctionalWords = SimilarityUtil.extractUriRelatedWords(service.getSemanticOperation().getSemanticConcepts());
			serviceFunctionalWords.addAll(SimilarityUtil.splitInWords(service.getSemanticOperation().getName()));
			serviceFunctionalWords.addAll(SimilarityUtil.extractUriRelatedWords(service.getSemanticInterface().getSemanticConcepts()));
			serviceFunctionalWords.addAll(SimilarityUtil.splitInWords(service.getSemanticInterface().getName()));
			
			funcRate = similarity.measureSimilarity(functionalWords, serviceFunctionalWords);
			res.setOperationRate(funcRate);
		}
		
		if(props.getInputOutputWeigth() != 0.0){
			List<String> serviceInputWords = SimilarityUtil.extractElementRelatedWords(ServiceUtil.getFlattenElements(service.getInputSemanticElement()));
			res.setInputRate(similarity.measureSimilarity(inputWords, serviceInputWords));

			List<String> serviceOutputWords = SimilarityUtil.extractElementRelatedWords(ServiceUtil.getFlattenElements(service.getOutputSemanticElement()));
			res.setOutputRate(similarity.measureSimilarity(outputWords, serviceOutputWords));

			ioRate = (res.getInputRate() + res.getOutputRate()) / 2.0;
		}
		
		// If one weight is set to 0, we only consider the other one
		if(ioRate == null || ioRate.isNaN()){
			res.setProfileRate(funcRate);
		} else if(funcRate == null || funcRate.isNaN()){
			res.setProfileRate(ioRate);
		} else {
			res.setProfileRate((ioRate * props.getInputOutputWeigth()) 
							+ (funcRate * props.getOperationWeight()));
		}
		
		return res;
	}

}
