/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile.rated;

import com.petalslink.easiersbs.matching.service.api.matcher.DegreeOfMatch;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class RatedSemanticProfileImpl implements RatedSemanticProfile {

	SemanticProfile profile;
	
	double profileRate = 0.0;
	double operationRate = 0.0;
	double inputRate = 0.0;
	DegreeOfMatch inputCoverage = DegreeOfMatch.UNKNOWN;
	double outputRate = 0.0;
	DegreeOfMatch outputCoverage = DegreeOfMatch.UNKNOWN;
	
	public RatedSemanticProfileImpl(SemanticProfile profile){
		this.profile = profile;
	}
	
	public RatedSemanticProfileImpl(SemanticProfile profile, 
									double profileRate, double opRate,
									double inputRate, DegreeOfMatch inputCoverage,
									double outputRate, DegreeOfMatch outputCoverage) {
		this.profile = profile;
		this.profileRate = profileRate;
		this.operationRate = opRate;
		this.inputRate = inputRate;
		this.inputCoverage = inputCoverage;
		this.outputRate = outputRate;
		this.outputCoverage = outputCoverage;
	}
	
	public double getProfileRate() {
		return profileRate;
	}

	public void setProfileRate(double profileRate) {
		this.profileRate = profileRate;
	}

	public double getOperationRate() {
		return operationRate;
	}

	public void setOperationRate(double operationRate) {
		this.operationRate = operationRate;
	}

	public double getInputRate() {
		return inputRate;
	}

	public void setInputRate(double inputRate) {
		this.inputRate = inputRate;
	}

	public DegreeOfMatch getInputCoverage() {
		return inputCoverage;
	}

	public void setInputCoverage(DegreeOfMatch inputCoverage) {
		this.inputCoverage = inputCoverage;
	}

	public double getOutputRate() {
		return outputRate;
	}

	public void setOutputRate(double outputRate) {
		this.outputRate = outputRate;
	}

	public DegreeOfMatch getOutputCoverage() {
		return outputCoverage;
	}

	public void setOutputCoverage(DegreeOfMatch outputCoverage) {
		this.outputCoverage = outputCoverage;
	}

	public SemanticProfile getProfile() {
		return profile;
	}

	@Override
	public int compareTo(RatedSemanticProfile other) {
		if(profileRate > other.getProfileRate()){
			return -1;
		} else if (profileRate == other.getProfileRate()
				&& profile.getOperations().equals(other.getProfile().getOperations())){
			return 0;
		} else {
			return 1;
		}
	}
	
	@Override
	public String toString(){
		String res = "Profile: " + profile.getOperations() + " - rate: " + profileRate;
		res += "\n Op: " + operationRate;
		res += " - In: " + inputRate + " (" + inputCoverage + ")";
		res += " - Out: " + outputRate + " (" + outputCoverage + ")";
		return res;
	}
	
	@Override
	public int hashCode() {
		return profile.hashCode();
	}
	
	@Override
	public boolean equals(Object other) {
		return profile.equals(other);
	}

}
