package org.petalslink.easiestdemo.client.gui.edit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;

public class XMLDocument extends DefaultStyledDocument {

    public static String TAG_ELEMENT="tag_element";
    public static String TAG_ROW_START_ELEMENT="tag_row_start_element";
    public static String TAG_ROW_END_ELEMENT="tag_row_end_element";

    /** Attributes for XML element tag. */
    private MutableAttributeSet element = null;

    /** Attributes for element value. */
    private MutableAttributeSet elementValue = null;

    /** Attributes for XML attribute. */
    private MutableAttributeSet attribute = null;

    /** Attributes for attribute value. */
    private MutableAttributeSet attributeValue = null;

    private DocumentBuilder db;

    @Override
    protected void finalize() throws Throwable {
        super.finalize();

        DocumentBuilders.releaseDocumentBuilder(this.db);
    }

    public XMLDocument() {

        this.db = DocumentBuilders.takeDocumentBuilder();

        element = new SimpleAttributeSet();
        StyleConstants.setForeground(element, new Color(51,102,102)); // green
        elementValue = new SimpleAttributeSet();
        StyleConstants.setForeground(elementValue, Color.black);
        attribute = new SimpleAttributeSet();
        StyleConstants.setForeground(attribute, new Color(153,51,153)); // purple
        attributeValue = new SimpleAttributeSet();
        StyleConstants.setForeground(attributeValue, Color.blue);
    }

    @Override
    public void insertString(int arg0, String arg1, AttributeSet arg2)
            throws BadLocationException {
        super.insertString(arg0, arg1, arg2);
        colorize();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        colorize();
    }

    /**
     * Called when document content changed to revalidate syntax highlightning.
     * Only works correctly for well-formed XML.
     * @throws BadLocationException
     */
    private void colorize() throws BadLocationException {

        String text = this.getText(0, getLength());
        int startIndex = 0;
        int endIndex = text.length() + 1;
        int openIndex = 0;
        int closeIndex = 0;
        boolean outOfTag = true;
        boolean attribute = false;
        boolean attributeValue = false;
        boolean egalValue = false;
        boolean print = true;
        int lastOpenIndex = -1;

        boolean testIfXmlDocument = false;

        if(text.endsWith(">")){

            testIfXmlDocument = true;
        }else{
            testIfXmlDocument = false;
        }
        try{
            if(testIfXmlDocument) {
                while (startIndex <= endIndex) {
                    openIndex = text.indexOf('<', startIndex); //next '<'
                    closeIndex = text.indexOf('>', startIndex); //next '>'

                    if(lastOpenIndex > openIndex) {
                        break;
                    }
                    if(openIndex != -1 && closeIndex == -1) {
                        break;
                    }
                    if (outOfTag) {
                        if (openIndex >= 0) {
                            setCharacterAttributes(startIndex, openIndex - startIndex, this.elementValue, false);
                            startIndex = openIndex;
                            outOfTag = false;
                            attribute = false;
                        } else {
                            setCharacterAttributes(startIndex, endIndex + 1, this.elementValue, false);
                            attribute = false;
                            break;
                        }
                    } else { //withinTag
                        if (closeIndex >= 0) {
                            for(int i = startIndex; i < closeIndex+1; i++) {
                                String character = text.substring(i, i + 1);
                                if(character.equals(" ")) {
                                    if(attribute == true) {
                                        attribute = false;
                                    } else {
                                        attribute = true;
                                    }
                                }
                                if(character.equals("\"")) {
                                    if(attributeValue == true) {
                                        attributeValue = false;
                                        print = false;
                                        setCharacterAttributes(i, i + 1, this.attributeValue, false);
                                    } else {
                                        attributeValue = true;
                                        attribute = false;
                                    }
                                }
                                if(character.equals(">")) {
                                    attribute = false;
                                    attributeValue = false;
                                }
                                if(character.equals("=")) {
                                    egalValue = true;
                                    attribute = false;
                                    attributeValue = false;
                                } 

                                if(print) {
                                    if(attribute) {
                                        setCharacterAttributes(i, i + 1, this.attribute, false);
                                    } else if(attributeValue) {
                                        setCharacterAttributes(i, i + 1, this.attributeValue, false);
                                    } else if(egalValue) {
                                        setCharacterAttributes(i, i + 1, this.elementValue, false);
                                        egalValue = false;
                                    } else {
                                        setCharacterAttributes(i, i + 1, this.element, false);
                                    }
                                }

                                if(character.equals("\"")) {
                                    print = true;
                                }
                            }
                            startIndex = closeIndex + 1;
                            outOfTag = true;
                            attribute = false;
                            attributeValue = false;
                            egalValue = false;
                        } else {
                            setCharacterAttributes(startIndex, endIndex + 1, this.element, false);
                        }
                    }
                    lastOpenIndex = openIndex;
                }
            }
        }catch (Exception e) {
            //do nothing
        }
    }
}
