package org.petalslink.easiestdemo.client.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;

import org.xml.sax.InputSource;


public class SpecificClasspathURIResolver implements URIResolver {


    @Override
    public Source resolve(String hRef, String baseURI) throws TransformerException {
        try {
            if(hRef != null) {
                if(hRef.startsWith("./")) {
                    hRef = hRef.replace("./", "");
                }
                URL url = Thread.currentThread().getContextClassLoader().getResource(hRef);
                if(url != null) {
                    return new SAXSource(new InputSource(url.openStream()));
                }
            }
            if(baseURI != null) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(baseURI);
                if(url != null) {
                    return new SAXSource(new InputSource(url.openStream()));
                }
            }
        } catch (MalformedURLException e) {
            throw new TransformerException(e);
        } catch (IOException e) {
            throw new TransformerException(e);
        } 

        return null;
    }



}
