/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.petalslink.easiestdemo.client.ThreadMsgSender;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.gui.edit.XMLEditorKit;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.topology.ExternalEndpointG;
import org.petalslink.easiestdemo.client.topology.menu.action.OperationListModel;

public class CallWebServiceFrame
extends JFrame {
    private WSOUIClient client;
    private Registry registry;
    private ExternalEndpointG endpointToCall;
    private JButton jButtonPlay;
    private JEditorPane jEditorPaneRequest;
    private JEditorPane jEditorPaneResponse;
    private JLabel jLabelChooseOperation;
    private JLabel jLabelEndpointName;
    private JLabel jLabelImage;
    private JLabel jLabelInterfaceQName;
    private JLabel jLabelOperationName;
    private JLabel jLabelSendTo;
    private JLabel jLabelServiceQName;
    private JList jListOperation;
    private JPanel jPanelMain;
    private JPanel jPanelRequest;
    private JPanel jPanelResponse;
    private JScrollPane jScrollPaneOperation;
    private JScrollPane jScrollPaneRequest;
    private JScrollPane jScrollPaneResponse;
    private JTextField jTextFieldEndpointName;
    private JTextField jTextFieldInterfaceQName;
    private JTextField jTextFieldOperationName;
    private JTextField jTextFieldSendTo;
    private JTextField jTextFieldServiceQName;

    public CallWebServiceFrame(WSOUIClient client, ExternalEndpointG endpointToCall) {
        this.initComponents();
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.jPanelRequest.setOpaque(false);
        this.jPanelResponse.setOpaque(false);
        this.client = client;
        this.registry = client.getRegistry();
        this.endpointToCall = endpointToCall;
        this.setTitle("Call WebService Endpoint: " + this.endpointToCall.getQName().getLocalPart());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
        this.jLabelImage.setIcon(new ImageIcon(WSOUIClient.CLIENT_IMAGE));
        this.jEditorPaneRequest.setEditorKit(new XMLEditorKit());
        this.jEditorPaneResponse.setEditorKit(new XMLEditorKit());
        this.jButtonPlay.setIcon(this.createImageIcon(this.jButtonPlay, WSOUIClient.ICON_PLAY));
        this.setLocation();
        List<MockOperation> operations = this.getAllOperations(this.endpointToCall.getMockEndpoint());
        this.jListOperation.setModel(new OperationListModel(operations));
        this.jTextFieldEndpointName.setText(this.endpointToCall.getMockEndpoint().getName());
        this.jTextFieldInterfaceQName.setText(this.endpointToCall.getMockEndpoint().getBinding().getInterfaceQName().toString());
        this.jTextFieldSendTo.setText(this.endpointToCall.getMockEndpoint().getAddress());
        this.jTextFieldServiceQName.setText(this.endpointToCall.getMockEndpoint().getService().getQName().toString());
    }

    private List<MockOperation> getAllOperations(MockEndpoint mockEndpoint) {
        ArrayList<MockOperation> res = new ArrayList<MockOperation>();
        MockService s = mockEndpoint.getService();
        ArrayList<MockEndpoint> endpoints = new ArrayList<MockEndpoint>();
        for (MockEndpoint ep : s.getEndpoints()) {
            if (!ep.getName().equals(mockEndpoint.getName())) continue;
            endpoints.add(ep);
        }
        for (MockEndpoint ep : endpoints) {
            res.addAll(ep.getBinding().getOperations());
        }
        return res;
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private ImageIcon createImageIcon(JButton button, URL url) {
        ImageIcon icon = new ImageIcon(url);
        Image img = icon.getImage();
        Image newImg = img.getScaledInstance(button.getWidth(), button.getHeight(), 4);
        icon = new ImageIcon(newImg);
        return icon;
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabelServiceQName = new JLabel();
        this.jLabelInterfaceQName = new JLabel();
        this.jTextFieldServiceQName = new JTextField();
        this.jTextFieldInterfaceQName = new JTextField();
        this.jLabelEndpointName = new JLabel();
        this.jTextFieldEndpointName = new JTextField();
        this.jLabelOperationName = new JLabel();
        this.jTextFieldOperationName = new JTextField();
        this.jLabelSendTo = new JLabel();
        this.jTextFieldSendTo = new JTextField();
        this.jPanelRequest = new JPanel();
        this.jScrollPaneRequest = new JScrollPane();
        this.jEditorPaneRequest = new JEditorPane();
        this.jButtonPlay = new JButton();
        this.jPanelResponse = new JPanel();
        this.jScrollPaneResponse = new JScrollPane();
        this.jEditorPaneResponse = new JEditorPane();
        this.jLabelChooseOperation = new JLabel();
        this.jScrollPaneOperation = new JScrollPane();
        this.jListOperation = new JList();
        this.jLabelImage = new JLabel();
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(102, 255, 102));
        this.setForeground(Color.green);
        this.jLabelServiceQName.setText("Service QName:");
        this.jLabelInterfaceQName.setText("Interface QName:");
        this.jTextFieldServiceQName.setEditable(false);
        this.jTextFieldInterfaceQName.setEditable(false);
        this.jLabelEndpointName.setText("Endpoint Name:");
        this.jTextFieldEndpointName.setEditable(false);
        this.jLabelOperationName.setText("Operation Name:");
        this.jTextFieldOperationName.setEditable(false);
        this.jLabelSendTo.setText("Send to:");
        this.jPanelRequest.setBorder(BorderFactory.createTitledBorder("Request:"));
        this.jScrollPaneRequest.setViewportView(this.jEditorPaneRequest);
        GroupLayout jPanelRequestLayout = new GroupLayout(this.jPanelRequest);
        this.jPanelRequest.setLayout(jPanelRequestLayout);
        jPanelRequestLayout.setHorizontalGroup(jPanelRequestLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRequestLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneRequest, -1, 361, Short.MAX_VALUE).addContainerGap()));
        jPanelRequestLayout.setVerticalGroup(jPanelRequestLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRequestLayout.createSequentialGroup().addComponent(this.jScrollPaneRequest, -1, 459, Short.MAX_VALUE).addContainerGap()));
        this.jButtonPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallWebServiceFrame.this.jButtonPlayActionPerformed(evt);
            }
        });
        this.jPanelResponse.setBorder(BorderFactory.createTitledBorder("Response:"));
        this.jScrollPaneResponse.setViewportView(this.jEditorPaneResponse);
        GroupLayout jPanelResponseLayout = new GroupLayout(this.jPanelResponse);
        this.jPanelResponse.setLayout(jPanelResponseLayout);
        jPanelResponseLayout.setHorizontalGroup(jPanelResponseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelResponseLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneResponse, -1, 356, Short.MAX_VALUE).addContainerGap()));
        jPanelResponseLayout.setVerticalGroup(jPanelResponseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelResponseLayout.createSequentialGroup().addComponent(this.jScrollPaneResponse, -1, 459, Short.MAX_VALUE).addContainerGap()));
        this.jLabelChooseOperation.setText("Choose operation:");
        this.jListOperation.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListOperation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CallWebServiceFrame.this.jListOperationMouseClicked(evt);
            }
        });
        this.jScrollPaneOperation.setViewportView(this.jListOperation);
        this.jLabelImage.setHorizontalAlignment(0);
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1198, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelImage, -1, 277, Short.MAX_VALUE).addComponent(this.jLabelChooseOperation, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneOperation, -1, 277, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jPanelRequest, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPlay, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelResponse, -2, -1, -2)).addGroup(jPanelMainLayout.createSequentialGroup().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 237, -2).addComponent(this.jLabelSendTo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldSendTo, -2, 511, -2)).addGroup(jPanelMainLayout.createSequentialGroup().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelServiceQName).addGroup(jPanelMainLayout.createSequentialGroup().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelInterfaceQName).addComponent(this.jLabelEndpointName).addComponent(this.jLabelOperationName)).addGap(18, 18, 18).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldOperationName, -1, 340, Short.MAX_VALUE).addComponent(this.jTextFieldEndpointName, -1, 490, Short.MAX_VALUE).addComponent(this.jTextFieldInterfaceQName, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldServiceQName, GroupLayout.Alignment.LEADING, -2, 490, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 204, Short.MAX_VALUE))).addGap(106, 106, 106))).addContainerGap())));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 658, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelServiceQName).addComponent(this.jTextFieldServiceQName, -2, -1, -2).addComponent(this.jLabelChooseOperation)).addGap(7, 7, 7).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jScrollPaneOperation, -2, 387, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelImage, -1, -1, Short.MAX_VALUE)).addGroup(jPanelMainLayout.createSequentialGroup().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelInterfaceQName).addComponent(this.jTextFieldInterfaceQName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelEndpointName).addComponent(this.jTextFieldEndpointName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOperationName).addComponent(this.jTextFieldOperationName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSendTo, -2, -1, -2).addComponent(this.jLabelSendTo)).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addGap(264, 264, 264).addComponent(this.jButtonPlay, -2, 78, -2)).addGroup(jPanelMainLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelResponse, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelRequest, GroupLayout.Alignment.LEADING, -2, -1, -2)))))).addContainerGap(14, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonPlayActionPerformed(ActionEvent evt) {
        if (this.jListOperation.getSelectedValue() != null) {
            ThreadMsgSender sender = new ThreadMsgSender((MockOperation)this.jListOperation.getSelectedValue(), this.jLabelImage, this.jEditorPaneRequest, this.jEditorPaneResponse, this.jTextFieldSendTo.getText(), this.client);
            sender.start();
        }
    }

    private void jListOperationMouseClicked(MouseEvent evt) {
        if (this.jListOperation.getSelectedValue() != null) {
            MockOperation op = (MockOperation)this.jListOperation.getSelectedValue();
            this.jTextFieldOperationName.setText(op.getName());
            this.jEditorPaneRequest.setText(op.getRequest());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CallWebServiceFrame(null, null).setVisible(true);
            }
        });
    }
}

