/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology.menu.action;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.gui.edit.XMLEditorKit;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.w3c.dom.Document;

public class GetStateFrame
extends JFrame {
    private WSOUIClient client;
    private Registry registry;
    private EsbG node = null;
    private JButton jButtonOK;
    private JEditorPane jEditorPaneState;
    private JPanel jPanelMain;
    private JScrollPane jScrollPaneState;

    public GetStateFrame(WSOUIClient client, EsbG node) {
        this.initComponents();
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.node = node;
        this.setTitle("Get state of node: " + this.node.getQName().getLocalPart());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
        this.client = client;
        this.registry = client.getRegistry();
        this.setLocation();
        this.jEditorPaneState.setEditorKit(new XMLEditorKit());
        try {
            Document doc = this.registry.getStateOfNode(node.getModel());
            String msg = XMLPrettyPrinter.prettyPrint((Document)doc);
            this.jEditorPaneState.setText(msg);
        }
        catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Creation Interrupted", 0);
        }
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jScrollPaneState = new JScrollPane();
        this.jEditorPaneState = new JEditorPane();
        this.jButtonOK = new JButton();
        this.jScrollPaneState.setViewportView(this.jEditorPaneState);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetStateFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 794, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneState, -1, 774, Short.MAX_VALUE).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING)).addContainerGap())));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 536, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneState, -2, 483, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addComponent(this.jButtonOK).addContainerGap())));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GetStateFrame(null, null).setVisible(true);
            }
        });
    }
}

