/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ConnectMonitoring2EsbFrame.java
 *
 * Created on 6 avr. 2011, 23:44:38
 */

package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Toolkit;

import javax.swing.JOptionPane;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.topology.EsbG;

/**
 *
 * @author nsalatge
 */
public class ConnectMonitoring2EsbFrame extends javax.swing.JFrame {

	private WSOUIClient client;
	private Registry registry;
	
	private EsbG monitoring = null;
	private Node selectedNode = null;
	
    /** Creates new form ConnectMonitoring2EsbFrame */
    public ConnectMonitoring2EsbFrame(WSOUIClient client, EsbG monitoring) {
        initComponents();
        
        this.setTitle("Connect " + monitoring.getQName().getLocalPart() + " to:");
        if(client != null) {
			this.jPanelMain.setBackground(client.getColor());
		}
        
        this.monitoring = monitoring;
        
    	this.client = client;
		this.registry = client.getRegistry();

		this.jListNodes.setModel(new NodeListModel(this.registry.getEsbNodes()));
		this.jLabelBSM.setText("Connect monitoring node  \"" + monitoring.getQName().getLocalPart() + "\" to:");

		
        this.setLocation();
    }
    
	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
	}
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelMain = new javax.swing.JPanel();
        jLabelConnect = new javax.swing.JLabel();
        jScrollPaneNode = new javax.swing.JScrollPane();
        jListNodes = new javax.swing.JList();
        jButtonOK = new javax.swing.JButton();
        jLabelTo = new javax.swing.JLabel();
        jLabelESB = new javax.swing.JLabel();
        jLabelBSM = new javax.swing.JLabel();

        jLabelConnect.setText("Connect to node:");

        jListNodes.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jListNodes.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListNodesMouseClicked(evt);
            }
        });
        jScrollPaneNode.setViewportView(jListNodes);

        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jLabelTo.setText("to:");

        jLabelBSM.setText("connect bsm");

        javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
        jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelMainLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup()
                        .addComponent(jScrollPaneNode, javax.swing.GroupLayout.PREFERRED_SIZE, 250, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanelMainLayout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 175, Short.MAX_VALUE)
                                .addComponent(jButtonOK))
                            .addGroup(jPanelMainLayout.createSequentialGroup()
                                .addGap(39, 39, 39)
                                .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanelMainLayout.createSequentialGroup()
                                        .addGap(10, 10, 10)
                                        .addComponent(jLabelESB, javax.swing.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE))
                                    .addComponent(jLabelTo)))
                            .addGroup(jPanelMainLayout.createSequentialGroup()
                                .addGap(18, 18, 18)
                                .addComponent(jLabelBSM, javax.swing.GroupLayout.DEFAULT_SIZE, 204, Short.MAX_VALUE))))
                    .addComponent(jLabelConnect))
                .addContainerGap())
        );
        jPanelMainLayout.setVerticalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelMainLayout.createSequentialGroup()
                .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jButtonOK)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanelMainLayout.createSequentialGroup()
                                .addComponent(jLabelConnect)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jScrollPaneNode, javax.swing.GroupLayout.DEFAULT_SIZE, 372, Short.MAX_VALUE))))
                    .addGroup(jPanelMainLayout.createSequentialGroup()
                        .addGap(104, 104, 104)
                        .addComponent(jLabelBSM)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabelTo)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabelESB, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanelMain, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanelMain, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
    	try {
			this.registry.connectMonitoringToEsb(this.monitoring.getModel(), this.selectedNode);
			this.client.refreshAll();
			this.setVisible(false);
		} catch (WSOUIClientException e) {
			e.printStackTrace();
        	JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"Connect monitoring node Interrupted", JOptionPane.ERROR_MESSAGE);
		} 
    }//GEN-LAST:event_jButtonOKActionPerformed

    private void jListNodesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListNodesMouseClicked
        this.selectedNode = (Node) this.jListNodes.getSelectedValue();
        this.jLabelESB.setText(this.selectedNode.getQName().getLocalPart());
    }//GEN-LAST:event_jListNodesMouseClicked

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ConnectMonitoring2EsbFrame(null, null).setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonOK;
    private javax.swing.JLabel jLabelBSM;
    private javax.swing.JLabel jLabelConnect;
    private javax.swing.JLabel jLabelESB;
    private javax.swing.JLabel jLabelTo;
    private javax.swing.JList jListNodes;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JScrollPane jScrollPaneNode;
    // End of variables declaration//GEN-END:variables

}
