/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.easiestdemo.client.AddWsdlFrame;
import org.petalslink.easiestdemo.client.ThreadMsgSender;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.gui.MenuMouseRegistryTree;
import org.petalslink.easiestdemo.client.gui.NotificationServerListModel;
import org.petalslink.easiestdemo.client.gui.NotificationTableModel;
import org.petalslink.easiestdemo.client.gui.TreeRegistryCellRenderer;
import org.petalslink.easiestdemo.client.gui.TreeRegistryModel;
import org.petalslink.easiestdemo.client.gui.edit.XMLEditorKit;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.model.impl.RegistryImpl;
import org.petalslink.easiestdemo.client.notification.AddNotificationServerFrame;
import org.petalslink.easiestdemo.client.notification.FilterFrame;
import org.petalslink.easiestdemo.client.notification.NotificationConsumerMock;
import org.petalslink.easiestdemo.client.notification.NotifyGui;
import org.petalslink.easiestdemo.client.topology.TopologyView;

public class WSOUIClient
extends JFrame {
    private static Logger LOG = Logger.getLogger(WSOUIClient.class.getName());
    public static final URL CLIENT_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/client.png");
    public static final URL CLIENT_TEL_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/client_tel.png");
    public static final URL CLIENT_HAPPY_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/client_happy.png");
    public static final URL CLIENT_SAD_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/client_sad.png");
    public static final URL ICON_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/easylink-ico.png");
    public static final URL ICON_IMAGE_LOGO = Thread.currentThread().getContextClassLoader().getResource("images/easiestdemo.png");
    public static final URL ICON_PLAY = Thread.currentThread().getContextClassLoader().getResource("images/next-bleu-arrow.png");
    private Color color = new Color(138, 246, 236);
    private JColorChooser colorChooser = new JColorChooser(this.color);
    private Registry registry = null;
    private List<NotificationConsumer_NotifierEndpoint_Server> notificationServers = new ArrayList<NotificationConsumer_NotifierEndpoint_Server>();
    private NotificationConsumer_NotifierEndpoint_Server currentNotificationServer = null;
    private TopologyView topology;
    private MenuMouseRegistryTree mmr;
    private JButton jButtonAddNotificationServer;
    private JButton jButtonFilter;
    private JButton jButtonPlay;
    private JEditorPane jEditorPaneNotification;
    private JEditorPane jEditorPaneRequest;
    private JEditorPane jEditorPaneResponse;
    private JLabel jLabelEndpointName;
    private JLabel jLabelImage;
    private JLabel jLabelImageLogo;
    private JLabel jLabelInterfaceQName;
    private JLabel jLabelNotificationNumberOfServer;
    private JLabel jLabelNotificationServerAddress;
    private JLabel jLabelNotificationServerSelected;
    private JLabel jLabelOperationName;
    private JLabel jLabelSendTo;
    private JLabel jLabelServiceQName;
    private JLabel jLabelTotalNumberName;
    private JLabel jLabelTotalNumberValue;
    private JList jListNotificationServer;
    private JMenuBar jMenuBar;
    private JMenu jMenuEdit;
    private JMenu jMenuFile;
    private JMenuItem jMenuItemAddWSDL;
    private JMenuItem jMenuItemChangeColor;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemRefresh;
    private JPanel jPanelAllNotification;
    private JPanel jPanelLog;
    private JPanel jPanelNotificationEventClient;
    private JPanel jPanelProperties;
    private JPanel jPanelRequest;
    private JPanel jPanelResponse;
    private JPanel jPanelTopology;
    private JPanel jPanelView;
    private JPanel jPanelWebServiceClient;
    private JScrollPane jScrollPane;
    private JScrollPane jScrollPaneLog;
    private JScrollPane jScrollPaneNotificationEditor;
    private JScrollPane jScrollPaneNotificationTable;
    private JScrollPane jScrollPaneProperties;
    private JScrollPane jScrollPaneRequest;
    private JScrollPane jScrollPaneResponse;
    private JScrollPane jScrollPaneTree;
    private JSplitPane jSplitPaneTopology;
    private JTabbedPane jTabbedPane;
    private JTabbedPane jTabbedPaneAll;
    private JTable jTableNotification;
    private JTable jTableProperties;
    private JTextArea jTextAreaLog;
    private JTextField jTextFieldEndpointName;
    private JTextField jTextFieldInterfaceQName;
    private JTextField jTextFieldNotificationServer;
    private JTextField jTextFieldNumberOfNotificationReceived;
    private JTextField jTextFieldOperationName;
    private JTextField jTextFieldSendTo;
    private JTextField jTextFieldServiceQName;
    private JTree jTree;

    public WSOUIClient() throws WSOUIClientException {
        try {
            this.initComponents();
            this.setTitle("EasiestDEMO WSOUI Client");
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(ICON_IMAGE));
            this.mmr = new MenuMouseRegistryTree(this);
            this.registry = new RegistryImpl();
            this.jLabelImage.setIcon(new ImageIcon(CLIENT_IMAGE));
            this.jLabelImageLogo.setIcon(new ImageIcon(ICON_IMAGE_LOGO));
            this.setLocation();
            this.jEditorPaneRequest.setEditorKit(new XMLEditorKit());
            this.jEditorPaneResponse.setEditorKit(new XMLEditorKit());
            this.jButtonPlay.setIcon(this.createImageIcon(this.jButtonPlay, ICON_PLAY));
            this.jEditorPaneNotification.setEditorKit(new XMLEditorKit());
            this.jTextFieldNotificationServer.setEditable(false);
            this.jTextFieldNumberOfNotificationReceived.setEditable(false);
            this.topology = new TopologyView(this.jPanelView.getSize(), this);
            this.jPanelView.setLayout(new GridLayout(1, 1));
            this.jPanelView.add(this.topology);
            this.refreshAll();
            this.refreshListNotification();
            this.setColor();
            this.jTableNotification.setModel(new NotificationTableModel(new ArrayList<NotifyGui>()));
        }
        catch (SOAPException e) {
            throw new WSOUIClientException(e);
        }
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public TopologyView getTopology() {
        return this.topology;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor() {
        this.jTabbedPane.setBackground(this.color);
        this.jPanelWebServiceClient.setBackground(this.color);
        this.jPanelNotificationEventClient.setBackground(this.color);
        this.jPanelRequest.setBackground(this.color);
        this.jPanelResponse.setBackground(this.color);
        this.jPanelLog.setBackground(this.color);
        this.jPanelProperties.setBackground(this.color);
    }

    public NotificationConsumer_NotifierEndpoint_Server[] getNotificationServers() {
        return this.notificationServers.toArray(new NotificationConsumer_NotifierEndpoint_Server[this.notificationServers.size()]);
    }

    public NotificationConsumer_NotifierEndpoint_Server getCurrentNotificationServer() {
        return this.currentNotificationServer;
    }

    private WSOUIClient getFrame() {
        return this;
    }

    public MenuMouseRegistryTree getMmr() {
        return this.mmr;
    }

    public void setMmr(MenuMouseRegistryTree mmr) {
        this.mmr = mmr;
    }

    public void refreshAll() throws WSOUIClientException {
        try {
            this.jTree.setModel(new TreeRegistryModel(this.registry));
            this.jTree.setCellRenderer(new TreeRegistryCellRenderer());
            this.jTree.paint(this.jTree.getGraphics());
            this.topology.refresh();
            this.printAllNotifications();
        }
        catch (SOAPException e) {
            throw new WSOUIClientException(e);
        }
    }

    public void refreshListNotification() {
        this.jListNotificationServer.setModel(new NotificationServerListModel(this.notificationServers));
    }

    public void addNewNotificationServers(String ... servers) throws WSOUIClientException {
        try {
            if (servers != null) {
                for (String serverAddress : servers) {
                    NotificationConsumerMock notifier = new NotificationConsumerMock(this);
                    NotificationConsumer_NotifierEndpoint_Server notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, serverAddress);
                    this.notificationServers.add(notifServer);
                }
                this.refreshListNotification();
            }
        }
        catch (Exception e) {
            throw new WSOUIClientException(e);
        }
    }

    public Node addNewAdminWsdlofESBNode(URL ... urls) throws WSOUIClientException {
        Node n = this.registry.addNewAdminWsdlofESBNode(urls);
        this.refreshAll();
        return n;
    }

    public void addNewWsdlofWebServices(URL ... urls) throws WSOUIClientException {
        this.registry.addNewWsdlofWebServices(urls);
        this.refreshAll();
    }

    public JTextField getjTextFieldEndpointName() {
        return this.jTextFieldEndpointName;
    }

    public JLabel getjLabelImage() {
        return this.jLabelImage;
    }

    public void setjLabelImage(JLabel jLabelImage) {
        this.jLabelImage = jLabelImage;
    }

    public void setjTextFieldEndpointName(JTextField jTextFieldEndpointName) {
        this.jTextFieldEndpointName = jTextFieldEndpointName;
    }

    public JTextField getjTextFieldInterfaceQName() {
        return this.jTextFieldInterfaceQName;
    }

    public void setjTextFieldInterfaceQName(JTextField jTextFieldInterfaceQName) {
        this.jTextFieldInterfaceQName = jTextFieldInterfaceQName;
    }

    public JEditorPane getjEditorPaneResponse() {
        return this.jEditorPaneResponse;
    }

    public void setjEditorPaneResponse(JEditorPane jEditorPaneResponse) {
        this.jEditorPaneResponse = jEditorPaneResponse;
    }

    public JTextField getjTextFieldOperationName() {
        return this.jTextFieldOperationName;
    }

    public void setjTextFieldOperationName(JTextField jTextFieldOperationName) {
        this.jTextFieldOperationName = jTextFieldOperationName;
    }

    public JTextField getjTextFieldNumberOfNotificationReceived() {
        return this.jTextFieldNumberOfNotificationReceived;
    }

    public JEditorPane getjEditorPaneRequest() {
        return this.jEditorPaneRequest;
    }

    public void setjEditorPaneRequest(JEditorPane jEditorPaneRequest) {
        this.jEditorPaneRequest = jEditorPaneRequest;
    }

    public JTextField getjTextFieldSendTo() {
        return this.jTextFieldSendTo;
    }

    public void setjTextFieldSendTo(JTextField jTextFieldSendTo) {
        this.jTextFieldSendTo = jTextFieldSendTo;
    }

    public JTextField getjTextFieldServiceQName() {
        return this.jTextFieldServiceQName;
    }

    public void setjTextFieldServiceQName(JTextField jTextFieldServiceQName) {
        this.jTextFieldServiceQName = jTextFieldServiceQName;
    }

    private ImageIcon createImageIcon(JButton button, URL url) {
        ImageIcon icon = new ImageIcon(url);
        Image img = icon.getImage();
        Image newImg = img.getScaledInstance(button.getWidth(), button.getHeight(), 4);
        icon = new ImageIcon(newImg);
        return icon;
    }

    public JTable getjTableNotification() {
        return this.jTableNotification;
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jPanelWebServiceClient = new JPanel();
        this.jScrollPaneTree = new JScrollPane();
        this.jTree = new JTree();
        this.jLabelImage = new JLabel();
        this.jPanelRequest = new JPanel();
        this.jScrollPaneRequest = new JScrollPane();
        this.jEditorPaneRequest = new JEditorPane();
        this.jButtonPlay = new JButton();
        this.jPanelResponse = new JPanel();
        this.jScrollPaneResponse = new JScrollPane();
        this.jEditorPaneResponse = new JEditorPane();
        this.jLabelSendTo = new JLabel();
        this.jTextFieldSendTo = new JTextField();
        this.jLabelServiceQName = new JLabel();
        this.jLabelInterfaceQName = new JLabel();
        this.jTextFieldServiceQName = new JTextField();
        this.jTextFieldInterfaceQName = new JTextField();
        this.jLabelEndpointName = new JLabel();
        this.jTextFieldEndpointName = new JTextField();
        this.jLabelOperationName = new JLabel();
        this.jTextFieldOperationName = new JTextField();
        this.jLabelImageLogo = new JLabel();
        this.jPanelNotificationEventClient = new JPanel();
        this.jLabelNotificationServerAddress = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.jListNotificationServer = new JList();
        this.jButtonAddNotificationServer = new JButton();
        this.jScrollPaneNotificationTable = new JScrollPane();
        this.jTableNotification = new JTable();
        this.jScrollPaneNotificationEditor = new JScrollPane();
        this.jEditorPaneNotification = new JEditorPane();
        this.jPanelAllNotification = new JPanel();
        this.jLabelTotalNumberName = new JLabel();
        this.jLabelTotalNumberValue = new JLabel();
        this.jLabelNotificationServerSelected = new JLabel();
        this.jTextFieldNotificationServer = new JTextField();
        this.jLabelNotificationNumberOfServer = new JLabel();
        this.jTextFieldNumberOfNotificationReceived = new JTextField();
        this.jButtonFilter = new JButton();
        this.jPanelTopology = new JPanel();
        this.jSplitPaneTopology = new JSplitPane();
        this.jPanelView = new JPanel();
        this.jTabbedPaneAll = new JTabbedPane();
        this.jPanelLog = new JPanel();
        this.jScrollPaneLog = new JScrollPane();
        this.jTextAreaLog = new JTextArea();
        this.jPanelProperties = new JPanel();
        this.jScrollPaneProperties = new JScrollPane();
        this.jTableProperties = new JTable();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemAddWSDL = new JMenuItem();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuEdit = new JMenu();
        this.jMenuItemChangeColor = new JMenuItem();
        this.jMenuItemRefresh = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jTabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WSOUIClient.this.jTabbedPaneMouseClicked(evt);
            }
        });
        this.jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WSOUIClient.this.jTreeMouseClicked(evt);
            }
        });
        this.jScrollPaneTree.setViewportView(this.jTree);
        this.jLabelImage.setHorizontalAlignment(0);
        this.jPanelRequest.setBorder(BorderFactory.createTitledBorder("Request:"));
        this.jScrollPaneRequest.setViewportView(this.jEditorPaneRequest);
        GroupLayout jPanelRequestLayout = new GroupLayout(this.jPanelRequest);
        this.jPanelRequest.setLayout(jPanelRequestLayout);
        jPanelRequestLayout.setHorizontalGroup(jPanelRequestLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRequestLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneRequest, -1, 363, Short.MAX_VALUE).addContainerGap()));
        jPanelRequestLayout.setVerticalGroup(jPanelRequestLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRequestLayout.createSequentialGroup().addComponent(this.jScrollPaneRequest, -1, 403, Short.MAX_VALUE).addContainerGap()));
        this.jButtonPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WSOUIClient.this.jButtonPlayActionPerformed(evt);
            }
        });
        this.jPanelResponse.setBorder(BorderFactory.createTitledBorder("Response:"));
        this.jScrollPaneResponse.setViewportView(this.jEditorPaneResponse);
        GroupLayout jPanelResponseLayout = new GroupLayout(this.jPanelResponse);
        this.jPanelResponse.setLayout(jPanelResponseLayout);
        jPanelResponseLayout.setHorizontalGroup(jPanelResponseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelResponseLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneResponse, -1, 310, Short.MAX_VALUE).addContainerGap()));
        jPanelResponseLayout.setVerticalGroup(jPanelResponseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelResponseLayout.createSequentialGroup().addComponent(this.jScrollPaneResponse, -1, 403, Short.MAX_VALUE).addContainerGap()));
        this.jLabelSendTo.setText("Send to:");
        this.jLabelServiceQName.setText("Service QName:");
        this.jLabelInterfaceQName.setText("Interface QName:");
        this.jTextFieldServiceQName.setEditable(false);
        this.jTextFieldInterfaceQName.setEditable(false);
        this.jLabelEndpointName.setText("Endpoint Name:");
        this.jTextFieldEndpointName.setEditable(false);
        this.jLabelOperationName.setText("Operation Name:");
        this.jTextFieldOperationName.setEditable(false);
        this.jLabelImageLogo.setHorizontalAlignment(0);
        GroupLayout jPanelWebServiceClientLayout = new GroupLayout(this.jPanelWebServiceClient);
        this.jPanelWebServiceClient.setLayout(jPanelWebServiceClientLayout);
        jPanelWebServiceClientLayout.setHorizontalGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelWebServiceClientLayout.createSequentialGroup().addContainerGap().addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneTree, -1, 280, Short.MAX_VALUE).addComponent(this.jLabelImage, -1, 280, Short.MAX_VALUE)).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelWebServiceClientLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jPanelRequest, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPlay, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelResponse, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelWebServiceClientLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSendTo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldSendTo, -2, 511, -2)).addGroup(jPanelWebServiceClientLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelWebServiceClientLayout.createSequentialGroup().addComponent(this.jLabelServiceQName, -1, 238, Short.MAX_VALUE).addGap(344, 344, 344)).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanelWebServiceClientLayout.createSequentialGroup().addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelEndpointName).addComponent(this.jLabelOperationName)).addGap(18, 18, 18).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldOperationName, -1, 340, Short.MAX_VALUE).addComponent(this.jTextFieldEndpointName))).addGroup(GroupLayout.Alignment.LEADING, jPanelWebServiceClientLayout.createSequentialGroup().addComponent(this.jLabelInterfaceQName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldServiceQName).addComponent(this.jTextFieldInterfaceQName, -1, 343, Short.MAX_VALUE))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelImageLogo, -1, 257, Short.MAX_VALUE))).addContainerGap()));
        jPanelWebServiceClientLayout.setVerticalGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelWebServiceClientLayout.createSequentialGroup().addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelWebServiceClientLayout.createSequentialGroup().addGap(38, 38, 38).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelInterfaceQName).addComponent(this.jTextFieldInterfaceQName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelEndpointName).addComponent(this.jTextFieldEndpointName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOperationName).addComponent(this.jTextFieldOperationName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSendTo, -2, -1, -2).addComponent(this.jLabelSendTo)).addGap(142, 142, 142).addComponent(this.jButtonPlay, -2, 78, -2)).addGroup(jPanelWebServiceClientLayout.createSequentialGroup().addContainerGap().addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelWebServiceClientLayout.createSequentialGroup().addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelImageLogo, -2, 95, -2).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelServiceQName).addComponent(this.jTextFieldServiceQName, -2, -1, -2))).addGap(46, 46, 46).addGroup(jPanelWebServiceClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelRequest, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelResponse, -1, -1, Short.MAX_VALUE)).addGap(21, 21, 21)).addGroup(jPanelWebServiceClientLayout.createSequentialGroup().addComponent(this.jScrollPaneTree, -1, 393, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelImage, -1, 207, Short.MAX_VALUE))))).addGap(0, 0, 0)));
        this.jTabbedPane.addTab("Web Service Client", this.jPanelWebServiceClient);
        this.jLabelNotificationServerAddress.setText("Notification servers address:");
        this.jListNotificationServer.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListNotificationServer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WSOUIClient.this.jListNotificationServerMouseClicked(evt);
            }
        });
        this.jScrollPane.setViewportView(this.jListNotificationServer);
        this.jButtonAddNotificationServer.setText("Add");
        this.jButtonAddNotificationServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WSOUIClient.this.jButtonAddNotificationServerActionPerformed(evt);
            }
        });
        this.jTableNotification.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Date", "From", "Notification"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, Object.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jTableNotification.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WSOUIClient.this.jTableNotificationMouseClicked(evt);
            }
        });
        this.jScrollPaneNotificationTable.setViewportView(this.jTableNotification);
        this.jScrollPaneNotificationEditor.setViewportView(this.jEditorPaneNotification);
        this.jPanelAllNotification.setBorder(BorderFactory.createBevelBorder(0));
        this.jLabelTotalNumberName.setFont(new Font("Tahoma", 1, 14));
        this.jLabelTotalNumberName.setHorizontalAlignment(0);
        this.jLabelTotalNumberName.setText("Total number of Notifcations :");
        this.jLabelTotalNumberValue.setFont(new Font("Tahoma", 1, 48));
        this.jLabelTotalNumberValue.setForeground(new Color(0, 102, 0));
        this.jLabelTotalNumberValue.setHorizontalAlignment(0);
        this.jLabelTotalNumberValue.setText("0");
        GroupLayout jPanelAllNotificationLayout = new GroupLayout(this.jPanelAllNotification);
        this.jPanelAllNotification.setLayout(jPanelAllNotificationLayout);
        jPanelAllNotificationLayout.setHorizontalGroup(jPanelAllNotificationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelAllNotificationLayout.createSequentialGroup().addContainerGap().addGroup(jPanelAllNotificationLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelTotalNumberValue, GroupLayout.Alignment.LEADING, -1, 296, Short.MAX_VALUE).addComponent(this.jLabelTotalNumberName, GroupLayout.Alignment.LEADING, -1, 296, Short.MAX_VALUE)).addContainerGap()));
        jPanelAllNotificationLayout.setVerticalGroup(jPanelAllNotificationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAllNotificationLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTotalNumberName).addGap(18, 18, 18).addComponent(this.jLabelTotalNumberValue, -2, 71, -2).addContainerGap(19, Short.MAX_VALUE)));
        this.jLabelNotificationServerSelected.setText("Notification server selected:");
        this.jLabelNotificationNumberOfServer.setText("Number of notification received:");
        this.jButtonFilter.setText("Filter");
        this.jButtonFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WSOUIClient.this.jButtonFilterActionPerformed(evt);
            }
        });
        GroupLayout jPanelNotificationEventClientLayout = new GroupLayout(this.jPanelNotificationEventClient);
        this.jPanelNotificationEventClient.setLayout(jPanelNotificationEventClientLayout);
        jPanelNotificationEventClientLayout.setHorizontalGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNotificationEventClientLayout.createSequentialGroup().addContainerGap().addGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelNotificationServerAddress).addComponent(this.jButtonAddNotificationServer).addComponent(this.jScrollPane, -1, 320, Short.MAX_VALUE).addComponent(this.jPanelAllNotification, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPaneNotificationEditor, 0, 0, Short.MAX_VALUE).addGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanelNotificationEventClientLayout.createSequentialGroup().addGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelNotificationNumberOfServer).addComponent(this.jLabelNotificationServerSelected)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldNotificationServer, GroupLayout.Alignment.LEADING, -2, 546, -2).addComponent(this.jTextFieldNumberOfNotificationReceived, GroupLayout.Alignment.LEADING))).addComponent(this.jScrollPaneNotificationTable, -2, 799, -2)).addComponent(this.jButtonFilter)).addContainerGap()));
        jPanelNotificationEventClientLayout.setVerticalGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNotificationEventClientLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelNotificationServerAddress).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelNotificationEventClientLayout.createSequentialGroup().addGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNotificationServerSelected).addComponent(this.jTextFieldNotificationServer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelNotificationEventClientLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNotificationNumberOfServer).addComponent(this.jTextFieldNumberOfNotificationReceived, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPaneNotificationTable, -1, 236, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneNotificationEditor, -2, 244, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilter).addGap(3, 3, 3)).addGroup(jPanelNotificationEventClientLayout.createSequentialGroup().addComponent(this.jScrollPane, -2, 395, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonAddNotificationServer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelAllNotification, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.jTabbedPane.addTab("Notification Event Client", this.jPanelNotificationEventClient);
        this.jSplitPaneTopology.setDividerLocation(500);
        this.jSplitPaneTopology.setOrientation(0);
        this.jSplitPaneTopology.setLastDividerLocation(500);
        this.jSplitPaneTopology.setOneTouchExpandable(true);
        GroupLayout jPanelViewLayout = new GroupLayout(this.jPanelView);
        this.jPanelView.setLayout(jPanelViewLayout);
        jPanelViewLayout.setHorizontalGroup(jPanelViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1155, Short.MAX_VALUE));
        jPanelViewLayout.setVerticalGroup(jPanelViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 499, Short.MAX_VALUE));
        this.jSplitPaneTopology.setTopComponent(this.jPanelView);
        this.jPanelLog.setName("Log");
        this.jTextAreaLog.setColumns(20);
        this.jTextAreaLog.setRows(5);
        this.jScrollPaneLog.setViewportView(this.jTextAreaLog);
        GroupLayout jPanelLogLayout = new GroupLayout(this.jPanelLog);
        this.jPanelLog.setLayout(jPanelLogLayout);
        jPanelLogLayout.setHorizontalGroup(jPanelLogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneLog, -1, 1150, Short.MAX_VALUE));
        jPanelLogLayout.setVerticalGroup(jPanelLogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneLog, -1, 83, Short.MAX_VALUE));
        this.jTabbedPaneAll.addTab("Log", this.jPanelLog);
        this.jTableProperties.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneProperties.setViewportView(this.jTableProperties);
        GroupLayout jPanelPropertiesLayout = new GroupLayout(this.jPanelProperties);
        this.jPanelProperties.setLayout(jPanelPropertiesLayout);
        jPanelPropertiesLayout.setHorizontalGroup(jPanelPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPropertiesLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneProperties, -1, 1130, Short.MAX_VALUE).addContainerGap()));
        jPanelPropertiesLayout.setVerticalGroup(jPanelPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPropertiesLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneProperties, -1, 61, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPaneAll.addTab("Properties", this.jPanelProperties);
        this.jSplitPaneTopology.setRightComponent(this.jTabbedPaneAll);
        GroupLayout jPanelTopologyLayout = new GroupLayout(this.jPanelTopology);
        this.jPanelTopology.setLayout(jPanelTopologyLayout);
        jPanelTopologyLayout.setHorizontalGroup(jPanelTopologyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneTopology, -1, 1157, Short.MAX_VALUE));
        jPanelTopologyLayout.setVerticalGroup(jPanelTopologyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneTopology, -1, 617, Short.MAX_VALUE));
        this.jTabbedPane.addTab("Topology", this.jPanelTopology);
        this.jMenuFile.setText("File");
        this.jMenuItemAddWSDL.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItemAddWSDL.setText("Add new WSDL");
        this.jMenuItemAddWSDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WSOUIClient.this.jMenuItemAddWSDLActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemAddWSDL);
        this.jMenuItemExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WSOUIClient.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuEdit.setText("Edit");
        this.jMenuItemChangeColor.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.jMenuItemChangeColor.setText("Change background color");
        this.jMenuItemChangeColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WSOUIClient.this.jMenuItemChangeColorActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemChangeColor);
        this.jMenuItemRefresh.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.jMenuItemRefresh.setText("Refresh All");
        this.jMenuItemRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WSOUIClient.this.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemRefresh);
        this.jMenuBar.add(this.jMenuEdit);
        this.setJMenuBar(this.jMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 1162, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 645, Short.MAX_VALUE));
        this.pack();
    }

    public JTable getjTableProperties() {
        return this.jTableProperties;
    }

    private void jButtonPlayActionPerformed(ActionEvent evt) {
        if (this.getMmr().getSelectedItem() != null) {
            ThreadMsgSender sender = new ThreadMsgSender((MockOperation)this.getMmr().getSelectedItem(), this.jLabelImage, this.jEditorPaneRequest, this.jEditorPaneResponse, this.jTextFieldSendTo.getText(), this);
            sender.start();
        }
    }

    private void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        try {
            this.refreshAll();
        }
        catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Refresh Interrupted", 0);
        }
    }

    private void jTabbedPaneMouseClicked(MouseEvent evt) {
        if (this.jTabbedPane.getSelectedIndex() == 1) {
            this.printAllNotifications();
        }
    }

    private void jButtonFilterActionPerformed(ActionEvent evt) {
        FilterFrame f = new FilterFrame(this, ((NotificationTableModel)this.jTableNotification.getModel()).getValue(this.jTableNotification.getSelectedRow()));
        f.setVisible(true);
    }

    private void jTreeMouseClicked(MouseEvent evt) {
        Object selectedItem;
        if (evt.getButton() == 1 && evt.getClickCount() == 1) {
            if (this.jTree.getSelectionPath() != null) {
                this.jTree.expandPath(this.jTree.getSelectionPath());
                Object selectedItem2 = this.jTree.getSelectionPath().getLastPathComponent();
                if (selectedItem2 != null) {
                    if (selectedItem2 instanceof MockService) {
                        this.mmr.setService((MockService)selectedItem2);
                    } else if (selectedItem2 instanceof MockEndpoint) {
                        this.mmr.setEndpoint((MockEndpoint)selectedItem2);
                    } else if (selectedItem2 instanceof MockBinding) {
                        this.mmr.setBinding((MockBinding)selectedItem2);
                    } else if (selectedItem2 instanceof MockOperation) {
                        MockOperation bop = (MockOperation)selectedItem2;
                        this.mmr.setOperation(bop);
                        this.jEditorPaneRequest.setText(bop.getRequest());
                    }
                    this.mmr.jMenuItemSetAllActionPerformed(null);
                }
            }
        } else if (evt.getButton() == 3 && evt.getClickCount() == 1 && this.jTree.getSelectionPath() != null && (selectedItem = this.jTree.getSelectionPath().getLastPathComponent()) != null) {
            if (selectedItem instanceof MockService) {
                this.mmr.setService((MockService)selectedItem);
            } else if (selectedItem instanceof Endpoint) {
                this.mmr.setEndpoint((MockEndpoint)selectedItem);
            } else if (selectedItem instanceof MockBinding) {
                this.mmr.setBinding((MockBinding)selectedItem);
            } else if (selectedItem instanceof MockOperation) {
                this.mmr.setOperation((MockOperation)selectedItem);
            }
            this.mmr.show(this.jTree, evt.getX(), evt.getY());
        }
    }

    private void jMenuItemAddWSDLActionPerformed(ActionEvent evt) {
        AddWsdlFrame newWsdl = new AddWsdlFrame(this);
        newWsdl.setVisible(true);
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jListNotificationServerMouseClicked(MouseEvent evt) {
        if (this.jListNotificationServer.getSelectedValue() != null) {
            this.currentNotificationServer = (NotificationConsumer_NotifierEndpoint_Server)this.jListNotificationServer.getSelectedValue();
            this.jTextFieldNotificationServer.setText(this.currentNotificationServer.getAddress());
            this.jTextFieldNumberOfNotificationReceived.setText(String.valueOf(((NotificationConsumerMock)this.currentNotificationServer.getImplementation()).getNotifications().size()));
            this.jTableNotification.setModel(new NotificationTableModel(((NotificationConsumerMock)this.currentNotificationServer.getImplementation()).getNotifications()));
        }
    }

    public void printAllNotifications() {
        int sum = 0;
        for (NotificationConsumer_NotifierEndpoint_Server server : this.notificationServers) {
            sum += ((NotificationConsumerMock)server.getImplementation()).getNotifications().size();
        }
        this.jLabelTotalNumberValue.setText(String.valueOf(sum));
    }

    private void jButtonAddNotificationServerActionPerformed(ActionEvent evt) {
        AddNotificationServerFrame server = new AddNotificationServerFrame(this);
        server.setVisible(true);
    }

    private void jTableNotificationMouseClicked(MouseEvent evt) {
        if (this.jTableNotification.getSelectedRow() != -1) {
            NotifyGui notify = ((NotificationTableModel)this.jTableNotification.getModel()).getValue(this.jTableNotification.getSelectedRow());
            this.jEditorPaneNotification.setText(notify.toString());
        }
    }

    private void jMenuItemChangeColorActionPerformed(ActionEvent evt) {
        ActionListener okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WSOUIClient.this.color = WSOUIClient.this.colorChooser.getColor();
                WSOUIClient.this.getFrame().setColor();
            }
        };
        JDialog dialog = JColorChooser.createDialog(null, "Change background color", true, this.colorChooser, okActionListener, null);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    WSOUIClient c = new WSOUIClient();
                    c.setVisible(true);
                }
                catch (WSOUIClientException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

