/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.petalslink.easiestdemo.client.gui.Property;
import org.petalslink.easiestdemo.client.model.api.gov.GovNode;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;
import org.petalslink.easiestdemo.client.topology.InternalClientProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.ProvidedServiceG;
import org.petalslink.easiestdemo.client.topology.TopologyView;

public class GovG {
    public static int DEFAULT_WIDTH = 150;
    public static int DEFAULT_HEIGHT = 100;
    private int lastx = 0;
    private int lasty = 0;
    private boolean move = false;
    private Rectangle rect;
    private TopologyView topology;
    private List<ProvidedServiceG> providedService = new ArrayList<ProvidedServiceG>();
    private List<Property> properties = new ArrayList<Property>();
    private GovNode model = null;

    public GovG(TopologyView topology, GovNode node, int init_x, int init_y) {
        this.model = node;
        this.topology = topology;
        this.rect = new Rectangle(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
        this.rect.setLocation(init_x, init_y);
        this.properties.add(new Property("name", ""));
        this.properties.add(new Property("namespace", ""));
        this.properties.add(new Property("port", ""));
        this.properties.add(new Property("number of provided service", this.model.getProvidedServices().size()));
    }

    public void update(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(8.0f));
        this.providedService.clear();
        for (ProvidedService cep : this.model.getProvidedServices()) {
            this.providedService.add(new ProvidedServiceG(this.topology, cep));
        }
        if (this.lastx == 0 && this.lasty == 0) {
            Dimension textSize = this.getTextSize(g2);
            if (textSize.width > DEFAULT_WIDTH) {
                this.rect.setSize(new Dimension(textSize.width + 10, DEFAULT_HEIGHT));
            }
        }
        if (this.move) {
            g2.setPaint(Color.white);
            g2.drawRect(this.lastx, this.lasty, (int)this.rect.getWidth(), (int)this.rect.getHeight());
            g2.fillRect(this.lastx, this.lasty, (int)this.rect.getWidth(), (int)this.rect.getHeight());
            this.lastx = this.rect.x;
            this.lasty = this.rect.y;
        }
        g2.setColor(new Color(132, 112, 255));
        g2.draw(this.rect);
        g2.setColor(new Color(255, 20, 147));
        g2.fill(this.rect);
        g2.setColor(Color.black);
        g2.drawString(this.model.getQName().getLocalPart(), this.rect.x + 5, this.rect.y + 15);
        int init_x = this.rect.x - InternalClientProxyEndpointG.DEFAULT_SIZE / 2;
        int spacey = this.rect.height / (this.providedService.size() + 1);
        int init_y = this.rect.y + spacey;
        for (ProvidedServiceG p : this.providedService) {
            p.setLocation(init_x, init_y);
            p.update(g2);
            init_y += spacey;
        }
    }

    private Dimension getTextSize(Graphics2D g2) {
        FontMetrics metrics = g2.getFontMetrics();
        int hgt = metrics.getHeight();
        int adv = metrics.stringWidth(this.model.getQName().getLocalPart());
        Dimension textSize = new Dimension(adv + 2, hgt + 2);
        return textSize;
    }

    public boolean contains(int x, int y) {
        return this.rect.contains(x, y);
    }

    public void setLocation(int x, int y) {
        Point pos = this.checkLocation(x, y);
        this.rect.x = pos.x;
        this.rect.y = pos.y;
    }

    private Point checkLocation(int x, int y) {
        Point p = new Point(x, y);
        if (x < this.topology.getX()) {
            p.x = this.topology.getX();
        } else if (x > this.topology.getX() + this.topology.getWidth() - this.rect.width) {
            p.x = this.topology.getX() + this.topology.getWidth() - this.rect.width;
        }
        if (y < this.topology.getY()) {
            p.y = this.topology.getY();
        } else if (y > this.topology.getY() + this.topology.getHeight() - this.rect.height) {
            p.y = this.topology.getY() + this.topology.getHeight() - this.rect.height;
        }
        return p;
    }

    public double getCenterX() {
        return this.rect.x + this.rect.width / 2;
    }

    public double getCenterY() {
        return this.rect.y + this.rect.height / 2;
    }

    public List<ProvidedServiceG> getProvidedServices() {
        return this.providedService;
    }

    public QName getQName() {
        return this.model.getQName();
    }

    public GovNode getModel() {
        return this.model;
    }

    public boolean isMove() {
        return this.move;
    }

    public void setMove(boolean move) {
        this.move = move;
    }

    public List<Property> getProperties() {
        return this.properties;
    }
}

