/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.petalslink.easiestdemo.client.model.impl.ws;

import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;

/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class MockEndpointImpl implements MockEndpoint {

	private Endpoint endpoint;
	private MockService service;
	private MockBinding binding;

	public MockEndpointImpl(MockService service, Endpoint endpoint) throws SOAPException {
		this.endpoint = endpoint;
		this.service = service;
		this.binding = new MockBindingImpl(this,endpoint.getBinding());
	}


	@Override
	public String getName() {
		return this.endpoint.getName();
	}


	@Override
	public MockService getService() {
		return this.service;
	}


	@Override
	public MockBinding getBinding() {
		return this.binding;
	}

	@Override
	public String getAddress() {
		return this.endpoint.getAddress();
	}
	
	public String toString() {
		return this.getName();
	}


}
