package org.petalslink.easiestdemo.client.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.swing.JOptionPane;

import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.gui.NotificationTableModel;

import com.ebmwebsourcing.wsstar.jaxb.notification.base.Notify;

public class NotificationConsumerMock implements NotificationConsumerDecorator {

	private static Logger LOG = Logger.getLogger(NotificationConsumerMock.class.getName());

	private final List<NotifyGui> notifications = new ArrayList<NotifyGui>();

	private WSOUIClient client = null;


	public NotificationConsumerMock(WSOUIClient client) {
		this.client = client;
	}

	public List<NotifyGui> getNotifications() {
		return this.notifications;
	}

	public void notify(final Notify notif) {
		LOG.finest("***************************** NEW NOTIFICATION ***********************");
		try {
			this.notifications.add(new NotifyGui(notif));
			if(this.client.getCurrentNotificationServer().getImplementation() == this) {
				this.client.getjTextFieldNumberOfNotificationReceived().setText(String.valueOf(this.notifications.size()));
				((NotificationTableModel)this.client.getjTableNotification().getModel()).addRow(this.notifications.size());
			}
			this.client.printAllNotifications();
		} catch (WSOUIClientException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(null, e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE); 
		}
	}

}
