/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ImportNodeFrame.java
 *
 * Created on 22 mars 2011, 22:54:01
 */

package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JOptionPane;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.gov.GovNode;
import org.petalslink.easiestdemo.client.model.impl.gov.GovNodeImpl;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;

/**
 *
 * @author nsalatge
 */
public class ImportGovFrame extends javax.swing.JFrame {

    private WSOUIClient client;
    private Registry registry;

    /** Creates new form ImportNodeFrame */
    public ImportGovFrame(WSOUIClient client) {
        initComponents();
        if(client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }

        this.setTitle("Import Governance");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));


        this.client = client;
        this.registry = client.getRegistry();

        this.setLocation();
    }


    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelMain = new javax.swing.JPanel();
        jLabelAdminServiceUrl = new javax.swing.JLabel();
        jTextFieldAdminServiceUrl = new javax.swing.JTextField();
        jButtonOk = new javax.swing.JButton();

        jLabelAdminServiceUrl.setText("Add administration service URL of governance framework to import:");

        jButtonOk.setText("OK");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
        jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelMainLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextFieldAdminServiceUrl, javax.swing.GroupLayout.DEFAULT_SIZE, 615, Short.MAX_VALUE)
                    .addComponent(jLabelAdminServiceUrl)
                    .addComponent(jButtonOk, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        jPanelMainLayout.setVerticalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelMainLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabelAdminServiceUrl)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldAdminServiceUrl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(29, 29, 29)
                .addComponent(jButtonOk)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanelMain, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanelMain, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed
        try {
            String adminUrl = this.jTextFieldAdminServiceUrl.getText();
            
            this.registry.importGovernace(adminUrl);
            this.client.getTopology().refresh();
            this.setVisible(false);
        } catch (SOAPException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this,
                    e.getMessage(), 
                    "Import governance Interrupted", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_jButtonOkActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ImportGovFrame(null).setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonOk;
    private javax.swing.JLabel jLabelAdminServiceUrl;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JTextField jTextFieldAdminServiceUrl;
    // End of variables declaration//GEN-END:variables

}
