/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * StoreBpelFrame.java
 *
 * Created on 22 mars 2011, 23:31:24
 */

package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.topology.EsbG;

/**
 *
 * @author nsalatge
 */
public class StoreBpelFrame extends javax.swing.JFrame {

	private WSOUIClient client;
	private Registry registry;
	private EsbG esb;
	
    /** Creates new form StoreBpelFrame */
    public StoreBpelFrame(WSOUIClient client, EsbG esb) {
        initComponents();
        if(client != null) {
			this.jPanelMain.setBackground(client.getColor());
		}
        
        this.esb = esb;
        this.setTitle("Store Bpel on node: " + esb.getQName().getLocalPart());
		this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
		
		
		this.client = client;
		this.registry = client.getRegistry();
		
		this.setLocation();
    }
    
    
	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
	}

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelMain = new javax.swing.JPanel();
        jLabelBpelUrl = new javax.swing.JLabel();
        jTextFieldBpelUrl = new javax.swing.JTextField();
        jButtonOk = new javax.swing.JButton();
        jButtonBrowse = new javax.swing.JButton();

        jLabelBpelUrl.setText("Bpel url:");

        jButtonOk.setText("OK");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        jButtonBrowse.setText("Browse...");
        jButtonBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBrowseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
        jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelMainLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabelBpelUrl)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldBpelUrl, javax.swing.GroupLayout.PREFERRED_SIZE, 499, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonBrowse)
                .addContainerGap())
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup()
                .addContainerGap(594, Short.MAX_VALUE)
                .addComponent(jButtonOk)
                .addContainerGap())
        );
        jPanelMainLayout.setVerticalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelMainLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelBpelUrl)
                    .addComponent(jTextFieldBpelUrl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonBrowse))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonOk)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanelMain, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed
    	try {
    		URL bpelURL = null;
    		if(new File(this.jTextFieldBpelUrl.getText()).exists()) {
    			bpelURL = new File(this.jTextFieldBpelUrl.getText()).toURI().toURL();
    		} else {
    			bpelURL = new URL(this.jTextFieldBpelUrl.getText());
    		}
    		
			this.registry.storeBpel(this.esb.getModel(), bpelURL);
			this.client.getTopology().clear();
			this.client.getTopology().refresh();
			this.setVisible(false);
		} catch (MalformedURLException e) {
			e.printStackTrace();
        	JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"Store bpel Interrupted", JOptionPane.ERROR_MESSAGE);
		} catch (WSOUIClientException e) {
			e.printStackTrace();
        	JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"Store bpel Interrupted", JOptionPane.ERROR_MESSAGE);
		}
    }//GEN-LAST:event_jButtonOkActionPerformed

    private void jButtonBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseActionPerformed
		JFileChooser c = new JFileChooser();
		c.addChoosableFileFilter(new BPELFilter());
		c.setAcceptAllFileFilterUsed(false);


		// Demonstrate "Open" dialog:
		int rVal = c.showOpenDialog(this);
		if (rVal == JFileChooser.APPROVE_OPTION) {
			jTextFieldBpelUrl.setText(c.getSelectedFile().getAbsolutePath());
		}
		if (rVal == JFileChooser.CANCEL_OPTION) {
			jTextFieldBpelUrl.setText("");
		}
    }//GEN-LAST:event_jButtonBrowseActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new StoreBpelFrame(null, null).setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonBrowse;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JLabel jLabelBpelUrl;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JTextField jTextFieldBpelUrl;
    // End of variables declaration//GEN-END:variables

}
