/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.notification;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.petalslink.easiestdemo.client.WSOUIClient;

public class AddNotificationServerFrame
extends JFrame {
    private WSOUIClient client;
    private int port = 9900;
    private static int cpt = 0;
    private JButton jButtonOK;
    private JLabel jLabelHost;
    private JLabel jLabelName;
    private JLabel jLabelPort;
    private JPanel jPanelMain;
    private JTextField jTextFieldHost;
    private JTextField jTextFieldName;
    private JTextField jTextFieldPort;

    public AddNotificationServerFrame(WSOUIClient client) {
        this.initComponents();
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.setTitle("Add new notification server");
        this.client = client;
        this.jTextFieldHost.setText("localhost");
        this.jTextFieldHost.setEditable(false);
        this.jTextFieldPort.setText(String.valueOf(this.port + cpt));
        this.jTextFieldName.setText("NotificationEndpoint_" + cpt);
        ++cpt;
        this.setLocation();
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabelHost = new JLabel();
        this.jLabelPort = new JLabel();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldPort = new JTextField();
        this.jTextFieldHost = new JTextField();
        this.jButtonOK = new JButton();
        this.jLabelHost.setText("host:");
        this.jLabelPort.setText("port:");
        this.jLabelName.setText("name:");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddNotificationServerFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelPort).addComponent(this.jLabelName).addComponent(this.jLabelHost)).addGap(18, 18, 18).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldName, -1, 332, Short.MAX_VALUE).addComponent(this.jTextFieldPort, -1, 332, Short.MAX_VALUE).addComponent(this.jTextFieldHost, -1, 332, Short.MAX_VALUE))).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING)).addContainerGap())));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPort).addComponent(this.jTextFieldPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelHost).addComponent(this.jTextFieldHost, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonOK).addContainerGap(-1, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            int port = Integer.parseInt(this.jTextFieldPort.getText());
            String host = this.jTextFieldHost.getText();
            String name = this.jTextFieldName.getText();
            String address = "http://" + host + ":" + port + "/" + name;
            this.client.addNewNotificationServers(address);
            this.setVisible(false);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AddNotificationServerFrame(null).setVisible(true);
            }
        });
    }
}

