/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.model.impl;

import com.ebmwebsourcing.easierbsm.BSMFactoryImpl;
import com.ebmwebsourcing.easiergov.WSContainer;
import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServerConfig;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.petalslink.easiergov.core.container.Container;
import com.petalslink.easiergov.core.impl.config.ConfigurationImpl;
import com.petalslink.easiergov.resources.api.GovException;
import easybox.easyesb.petalslink.com.admin.model.datatype._1.EJaxbPropertyType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbNodeType;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNode;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNodeResponse;
import easyesb.petalslink.com.data.admin._1.AddProperties;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNode;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNodeResponse;
import easyesb.petalslink.com.data.admin._1.ObjectFactory;
import easyesb.petalslink.com.data.admin._1.StoreBpel;
import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.Endpoint;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.gov.GovNode;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.model.impl.esb.NodeImpl;
import org.petalslink.easiestdemo.client.model.impl.gov.GovNodeImpl;
import org.petalslink.easiestdemo.client.model.impl.ws.MockServiceImpl;
import org.w3c.dom.Document;

public class RegistryImpl
implements Registry {
    ESBFactory esbFactory = new ESBFactoryImpl();
    ESBFactory bsmFactory = new BSMFactoryImpl();
    List<org.petalslink.easiestdemo.client.model.api.esb.Node> nodes = new ArrayList<org.petalslink.easiestdemo.client.model.api.esb.Node>();
    List<MockService> webServices = new ArrayList<MockService>();
    GovNode govNode = null;
    private SOAPSender sender = new SOAPSender();

    @Override
    public List<org.petalslink.easiestdemo.client.model.api.esb.Node> getAllNodes() {
        return this.nodes;
    }

    @Override
    public List<MockService> getWebServices() {
        return this.webServices;
    }

    @Override
    public void importGovernace(String adminManagerAddress) throws SOAPException {
        this.govNode = new GovNodeImpl(adminManagerAddress, this);
    }

    @Override
    public void addNewWsdlofWebServices(URL ... urls) throws WSOUIClientException {
        try {
            if (urls != null) {
                for (URL url : urls) {
                    try {
                        Definitions definitions = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(url, Definitions.class);
                        Description desc = (Description)Factory.getInstance().wrap((XmlObject)definitions);
                        if (this.existInDescriptionList(this.getDescriptionsOfWebServices(), desc)) continue;
                        this.addDescriptionOfWebServices(desc);
                    }
                    catch (XmlObjectReadException e) {
                        throw new WSOUIClientException(e);
                    }
                }
            }
        }
        catch (SOAPException e) {
            throw new WSOUIClientException(e);
        }
    }

    @Override
    public void addDescriptionOfWebServices(Description ... descs) throws SOAPException {
        if (descs != null) {
            for (Description desc : descs) {
                for (Service s : desc.getServices()) {
                    this.webServices.add(new MockServiceImpl(s));
                }
            }
        }
    }

    @Override
    public org.petalslink.easiestdemo.client.model.api.esb.Node addNewAdminWsdlofESBNode(URL ... urls) throws WSOUIClientException {
        org.petalslink.easiestdemo.client.model.api.esb.Node n = null;
        try {
            if (urls != null) {
                for (URL url : urls) {
                    try {
                        Definitions definitions = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(url, Definitions.class);
                        Description desc = (Description)Factory.getInstance().wrap((XmlObject)definitions);
                        if (this.existInDescriptionList(this.getDescriptionsOfAdminESBNodes(), desc)) continue;
                        n = this.addDescriptionOfAdminEsbNode(desc);
                    }
                    catch (XmlObjectReadException e) {
                        throw new WSOUIClientException(e);
                    }
                }
            }
        }
        catch (SOAPException e) {
            throw new WSOUIClientException(e);
        }
        return n;
    }

    @Override
    public org.petalslink.easiestdemo.client.model.api.esb.Node addDescriptionOfAdminEsbNode(Description ... descs) throws SOAPException {
        NodeImpl n = null;
        if (descs != null) {
            for (Description desc : descs) {
                n = new NodeImpl(desc, this);
                this.nodes.add(n);
                for (ProviderEndpointProxy pep : n.getProviderEndpointProxies()) {
                    this.addDescriptionOfWebServices(pep.getDescription());
                }
            }
        }
        return n;
    }

    @Override
    public List<Description> getDescriptionsOfWebServices() {
        ArrayList<Description> descs = new ArrayList<Description>();
        for (MockService s : this.webServices) {
            descs.add(s.getDescription());
        }
        return descs;
    }

    @Override
    public List<Description> getDescriptionsOfAdminESBNodes() {
        ArrayList<Description> descs = new ArrayList<Description>();
        for (org.petalslink.easiestdemo.client.model.api.esb.Node n : this.nodes) {
            descs.add(n.getAdministrationServiceDescription());
        }
        return descs;
    }

    @Override
    public List<ClientEndpointProxy> getAllClientEndpointProxy() {
        ArrayList<ClientEndpointProxy> res = new ArrayList<ClientEndpointProxy>();
        for (org.petalslink.easiestdemo.client.model.api.esb.Node n : this.nodes) {
            res.addAll(n.getClientEndpointProxies());
        }
        return res;
    }

    @Override
    public List<MockEndpoint> getAllWebServicesPartnerEndpoint() {
        ArrayList<MockEndpoint> res = new ArrayList<MockEndpoint>();
        for (MockService s : this.webServices) {
            res.addAll(s.getEndpoints());
        }
        return res;
    }

    private boolean existInDescriptionList(List<Description> descriptions, Description desc) {
        boolean res = false;
        for (Description d : descriptions) {
            if (!d.getDocumentBaseURI().toString().equals(desc.getDocumentBaseURI().toString())) continue;
            res = true;
            break;
        }
        return res;
    }

    @Override
    public org.petalslink.easiestdemo.client.model.api.esb.Node findNodeByAdminUrl(URL adminUrl) throws WSOUIClientException {
        org.petalslink.easiestdemo.client.model.api.esb.Node res = null;
        try {
            for (org.petalslink.easiestdemo.client.model.api.esb.Node n : this.nodes) {
                URI baseUri = n.getAdministrationServiceDescription().getDocumentBaseURI();
                if (!baseUri.toString().equals(adminUrl.toURI().toString())) continue;
                res = n;
                break;
            }
        }
        catch (URISyntaxException e) {
            throw new WSOUIClientException(e);
        }
        return res;
    }

    @Override
    public void createNode(String nodeName, String nodeNameSpace, String host, String port, String soapPort, boolean monitoring) throws WSOUIClientException {
        try {
            com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl conf;
            Node node = null;
            String admin = null;
            if (!monitoring) {
                conf = new com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl(false, host, Integer.parseInt(port), new ExternalServer[]{new SoapServer(new SoapServerConfig(Integer.valueOf(soapPort).intValue()))});
                node = this.esbFactory.createNode(new QName(nodeNameSpace, nodeName), (Configuration)conf);
                admin = "http://" + host + ":" + soapPort + "/services/adminExternalEndpoint";
            } else {
                conf = new com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl(false, host, Integer.parseInt(port), new ExternalServer[]{new SoapServer(new SoapServerConfig(Integer.valueOf(soapPort).intValue()))});
                node = this.bsmFactory.createNode(new QName(nodeNameSpace, nodeName), (Configuration)conf);
                admin = "http://" + host + ":" + soapPort + "/services/bsmadminExternalEndpoint";
            }
            URL adminUrl = new URL(admin + "?wsdl");
            this.addNewAdminWsdlofESBNode(adminUrl);
            org.petalslink.easiestdemo.client.model.api.esb.Node n = this.findNodeByAdminUrl(adminUrl);
            n.setModel(node);
            n.setBasicInfos((EJaxbBasicNodeInformationsType)((NodeType)node.getModel()).getBasicNodeInformations().getModelObject());
            if (monitoring) {
                n.setMonitoringNode(true);
            }
        }
        catch (NumberFormatException e) {
            throw new WSOUIClientException(e);
        }
        catch (ESBException e) {
            throw new WSOUIClientException(e);
        }
        catch (MalformedURLException e) {
            throw new WSOUIClientException(e);
        }
        catch (WSOUIClientException e) {
            throw new WSOUIClientException(e);
        }
    }

    @Override
    public void addNeighBourNode(org.petalslink.easiestdemo.client.model.api.esb.Node source, org.petalslink.easiestdemo.client.model.api.esb.Node target) throws WSOUIClientException {
        try {
            AddNeighBourNode request = new AddNeighBourNode();
            request.setNeighbourNode(target.getBasicInfos());
            AddNeighBourNodeResponse response = source.getAdminClient().addNeighBourNode(request);
            source.getNeighbourNodeNames().add(target.getQName());
        }
        catch (AdminExceptionMsg e) {
            throw new WSOUIClientException(e);
        }
    }

    @Override
    public void storeBpel(org.petalslink.easiestdemo.client.model.api.esb.Node source, URL bpel) throws WSOUIClientException {
        try {
            StoreBpel request = new StoreBpel();
            request.setBpelUrl(bpel.toString());
            List response = source.getAdminClient().storeBpel(bpel.toString());
            this.getStateOfNode(source);
        }
        catch (AdminExceptionMsg e) {
            throw new WSOUIClientException(e);
        }
        catch (WSOUIClientException e) {
            throw new WSOUIClientException(e);
        }
    }

    @Override
    public void moveEndpointToNode(Endpoint endpoint, org.petalslink.easiestdemo.client.model.api.esb.Node targetNode, boolean addConnection) throws WSOUIClientException {
        try {
            if (endpoint == null && targetNode == null) {
                throw new ESBException("endpoint or target cannot be null");
            }
            org.petalslink.easiestdemo.client.model.api.esb.Node sourceNode = endpoint.getNode();
            QName endpointName = null;
            if (endpoint instanceof ProviderEndpointProxy) {
                endpointName = new QName(((ProviderEndpointProxy)endpoint).getService().getQName().getNamespaceURI(), ((ProviderEndpointProxy)endpoint).getEndpoint().getName());
            } else if (endpoint instanceof ClientEndpointProxy) {
                endpointName = ((ClientEndpointProxy)endpoint).getName();
            }
            if (sourceNode.getQName().equals(targetNode.getQName())) {
                throw new ESBException("target node must be different of source node");
            }
            MoveEnpointToNode payload = new MoveEnpointToNode();
            payload.setEndpointName(endpointName);
            payload.setBasicNodeInformations(targetNode.getBasicInfos());
            payload.setAddConnectionIfNotExist(addConnection);
            MoveEnpointToNodeResponse response = sourceNode.getAdminClient().moveEnpointToNode(payload);
            if (response.isSetGenericEndpoint()) {
                if (addConnection) {
                    sourceNode.getNeighbourNodeNames().add(targetNode.getQName());
                }
                if (endpoint instanceof ClientEndpointProxy) {
                    sourceNode.getClientEndpointProxies().remove(endpoint);
                }
                if (endpoint instanceof ProviderEndpointProxy) {
                    sourceNode.getProviderEndpointProxies().remove(endpoint);
                }
                if (endpoint instanceof ClientEndpointProxy) {
                    targetNode.getClientEndpointProxies().add((ClientEndpointProxy)endpoint);
                }
                if (endpoint instanceof ProviderEndpointProxy) {
                    targetNode.getProviderEndpointProxies().add((ProviderEndpointProxy)endpoint);
                }
            }
        }
        catch (ESBException e) {
            throw new WSOUIClientException(e);
        }
        catch (AdminExceptionMsg e) {
            throw new WSOUIClientException(e);
        }
    }

    @Override
    public Document getStateOfNode(org.petalslink.easiestdemo.client.model.api.esb.Node node) throws WSOUIClientException {
        Document doc = null;
        try {
            doc = node.getStateOfNode();
            com.ebmwebsourcing.easyesb.soa10.api.element.Node response = (com.ebmwebsourcing.easyesb.soa10.api.element.Node)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(doc, com.ebmwebsourcing.easyesb.soa10.api.element.Node.class);
            node.analyzeState((EJaxbNodeType)response.getInternalModel());
            boolean found = false;
            for (ProviderEndpointProxy pep : node.getProviderEndpointProxies()) {
                found = false;
                for (MockService service : this.webServices) {
                    for (MockEndpoint endpoint : service.getEndpoints()) {
                        if (!pep.getEndpoint().getName().equals(endpoint.getName())) continue;
                        found = true;
                    }
                }
                if (found) continue;
                this.webServices.add(new MockServiceImpl(pep.getService()));
            }
        }
        catch (SOAPException e) {
            throw new WSOUIClientException(e);
        }
        catch (XmlObjectReadException e) {
            throw new WSOUIClientException(e);
        }
        return doc;
    }

    @Override
    public void connectMonitoringToEsb(org.petalslink.easiestdemo.client.model.api.esb.Node monitoring, org.petalslink.easiestdemo.client.model.api.esb.Node esb) throws WSOUIClientException {
        try {
            AdminClient monitoringClient = monitoring.getAdminClient();
            AddProperties monitoringProperties = new AddProperties();
            EJaxbPropertyType esbConnexionProperty = new EJaxbPropertyType();
            esbConnexionProperty.setKey("esb-connection");
            esbConnexionProperty.setValue(esb.getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString());
            monitoringProperties.getProperty().add(esbConnexionProperty);
            monitoringClient.addProperties(monitoringProperties);
            AdminClient esbClient = esb.getAdminClient();
            AddProperties esbProperties = new AddProperties();
            EJaxbPropertyType wsdmEndpointCreationProperty = new EJaxbPropertyType();
            wsdmEndpointCreationProperty.setKey("rawreport-endpoint-creation-service-address");
            wsdmEndpointCreationProperty.setValue(monitoring.getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString());
            esbProperties.getProperty().add(wsdmEndpointCreationProperty);
            EJaxbPropertyType dispatcherServiceAddressProperty = new EJaxbPropertyType();
            dispatcherServiceAddressProperty.setKey("rawreport-service-address");
            dispatcherServiceAddressProperty.setValue(monitoring.getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString().replace("adminExternalEndpoint?wsdl", "DispatcherProviderEndpointClientProxyEndpoint"));
            esbProperties.getProperty().add(dispatcherServiceAddressProperty);
            esbClient.addProperties(esbProperties);
            monitoring.getMonitoredNodes().add(esb);
        }
        catch (MalformedURLException e) {
            throw new WSOUIClientException(e);
        }
        catch (AdminExceptionMsg e) {
            throw new WSOUIClientException(e);
        }
    }

    @Override
    public List<org.petalslink.easiestdemo.client.model.api.esb.Node> getMonitoringNodes() {
        ArrayList<org.petalslink.easiestdemo.client.model.api.esb.Node> res = new ArrayList<org.petalslink.easiestdemo.client.model.api.esb.Node>();
        for (org.petalslink.easiestdemo.client.model.api.esb.Node n : this.nodes) {
            if (!n.isMonitoringNode()) continue;
            res.add(n);
        }
        return res;
    }

    @Override
    public List<org.petalslink.easiestdemo.client.model.api.esb.Node> getEsbNodes() {
        ArrayList<org.petalslink.easiestdemo.client.model.api.esb.Node> res = new ArrayList<org.petalslink.easiestdemo.client.model.api.esb.Node>();
        for (org.petalslink.easiestdemo.client.model.api.esb.Node n : this.nodes) {
            if (n.isMonitoringNode()) continue;
            res.add(n);
        }
        return res;
    }

    @Override
    public GovNode getGovNode() {
        return this.govNode;
    }

    @Override
    public void createGovernance(String name, String namespace, String host, String port) throws GovException {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName(name);
        conf.setNamespace(namespace);
        conf.setHost(host);
        conf.setPort(Integer.valueOf(port).intValue());
        WSContainer container = new WSContainer((com.petalslink.easiergov.core.config.Configuration)conf);
        container.start();
        try {
            this.govNode = new GovNodeImpl("http://" + conf.getHost() + ":" + conf.getPort() + "/services/adminManager", this);
            this.govNode.setModel((Container)container);
        }
        catch (SOAPException e) {
            throw new GovException((Throwable)e);
        }
    }

    @Override
    public void bindWebServiceToNode(MockEndpoint wsToBind, org.petalslink.easiestdemo.client.model.api.esb.Node selectedNode) throws ESBException {
        try {
            AdminClientImpl esbClient = new AdminClientImpl(selectedNode.getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString());
            esbClient.importSoapEndpoint(wsToBind.getAddress(), wsToBind.getService().getDescription().getDocumentBaseURI().toString());
            this.getStateOfNode(selectedNode);
        }
        catch (MalformedURLException e) {
            throw new ESBException((Throwable)e);
        }
        catch (AdminExceptionMsg e) {
            throw new ESBException((Throwable)e);
        }
        catch (WSOUIClientException e) {
            throw new ESBException((Throwable)e);
        }
    }

    @Override
    public void refreshConnectionBetweenFramework() throws WSOUIClientException {
        if (this.govNode != null) {
            this.govNode.refreshConnectedNodes();
        }
        for (org.petalslink.easiestdemo.client.model.api.esb.Node n : this.getAllNodes()) {
            n.refreshMonitoredNodes();
        }
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

