/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * CallWebServiceFrame.java
 *
 * Created on 22 mars 2011, 15:01:38
 */

package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JButton;

import org.petalslink.easiestdemo.client.ThreadMsgSender;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.gui.edit.XMLEditorKit;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.topology.ExternalEndpointG;


/**
 *
 * @author nsalatge
 */
public class CallWebServiceFrame extends javax.swing.JFrame {

	private WSOUIClient client;
	private Registry registry;

	private ExternalEndpointG endpointToCall;

	/** Creates new form CallWebServiceFrame */
	public CallWebServiceFrame(WSOUIClient client, ExternalEndpointG endpointToCall) {
		initComponents();
		if(client != null) {
			this.jPanelMain.setBackground(client.getColor());
		}
		this.jPanelRequest.setOpaque(false);
		this.jPanelResponse.setOpaque(false);
		
		this.client = client;
		this.registry = client.getRegistry();

		this.endpointToCall = endpointToCall;
		
		this.setTitle("Call WebService Endpoint: " + this.endpointToCall.getQName().getLocalPart());
		this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));

		// panel web service
		this.jLabelImage.setIcon(new ImageIcon(WSOUIClient.CLIENT_IMAGE));
		this.jEditorPaneRequest.setEditorKit(new XMLEditorKit());
		this.jEditorPaneResponse.setEditorKit(new XMLEditorKit());
		this.jButtonPlay.setIcon(createImageIcon(this.jButtonPlay, WSOUIClient.ICON_PLAY));

		this.setLocation();

		List<MockOperation> operations = getAllOperations(this.endpointToCall.getMockEndpoint());
		
		this.jListOperation.setModel(new OperationListModel(operations));
		this.jTextFieldEndpointName.setText(this.endpointToCall.getMockEndpoint().getName());
		this.jTextFieldInterfaceQName.setText(this.endpointToCall.getMockEndpoint().getBinding().getInterfaceQName().toString());
		this.jTextFieldSendTo.setText(this.endpointToCall.getMockEndpoint().getAddress());
		this.jTextFieldServiceQName.setText(this.endpointToCall.getMockEndpoint().getService().getQName().toString());
	}

	private List<MockOperation> getAllOperations(MockEndpoint mockEndpoint) {
		List<MockOperation> res = new ArrayList<MockOperation>();
		MockService s = mockEndpoint.getService();
		
		List<MockEndpoint> endpoints = new ArrayList<MockEndpoint>();
		for(MockEndpoint ep: s.getEndpoints()) {
			if(ep.getName().equals(mockEndpoint.getName())) {
				endpoints.add(ep);
			}
		}
		
		for(MockEndpoint ep: endpoints) {
			res.addAll(ep.getBinding().getOperations());
		}
		
		return res;
	}

	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
	}


	private ImageIcon createImageIcon(JButton button, URL url) {
		ImageIcon icon = new ImageIcon(url);
		Image img = icon.getImage() ;
		Image newImg = img.getScaledInstance(button.getWidth(), button.getHeight(), java.awt.Image.SCALE_SMOOTH);
		icon = new ImageIcon(newImg);
		return icon;
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelMain = new javax.swing.JPanel();
        jLabelServiceQName = new javax.swing.JLabel();
        jLabelInterfaceQName = new javax.swing.JLabel();
        jTextFieldServiceQName = new javax.swing.JTextField();
        jTextFieldInterfaceQName = new javax.swing.JTextField();
        jLabelEndpointName = new javax.swing.JLabel();
        jTextFieldEndpointName = new javax.swing.JTextField();
        jLabelOperationName = new javax.swing.JLabel();
        jTextFieldOperationName = new javax.swing.JTextField();
        jLabelSendTo = new javax.swing.JLabel();
        jTextFieldSendTo = new javax.swing.JTextField();
        jPanelRequest = new javax.swing.JPanel();
        jScrollPaneRequest = new javax.swing.JScrollPane();
        jEditorPaneRequest = new javax.swing.JEditorPane();
        jButtonPlay = new javax.swing.JButton();
        jPanelResponse = new javax.swing.JPanel();
        jScrollPaneResponse = new javax.swing.JScrollPane();
        jEditorPaneResponse = new javax.swing.JEditorPane();
        jLabelChooseOperation = new javax.swing.JLabel();
        jScrollPaneOperation = new javax.swing.JScrollPane();
        jListOperation = new javax.swing.JList();
        jLabelImage = new javax.swing.JLabel();

        setAlwaysOnTop(true);
        setBackground(new java.awt.Color(102, 255, 102));
        setForeground(java.awt.Color.green);

        jLabelServiceQName.setText("Service QName:");

        jLabelInterfaceQName.setText("Interface QName:");

        jTextFieldServiceQName.setEditable(false);

        jTextFieldInterfaceQName.setEditable(false);

        jLabelEndpointName.setText("Endpoint Name:");

        jTextFieldEndpointName.setEditable(false);

        jLabelOperationName.setText("Operation Name:");

        jTextFieldOperationName.setEditable(false);

        jLabelSendTo.setText("Send to:");

        jPanelRequest.setBorder(javax.swing.BorderFactory.createTitledBorder("Request:"));

        jScrollPaneRequest.setViewportView(jEditorPaneRequest);

        javax.swing.GroupLayout jPanelRequestLayout = new javax.swing.GroupLayout(jPanelRequest);
        jPanelRequest.setLayout(jPanelRequestLayout);
        jPanelRequestLayout.setHorizontalGroup(
            jPanelRequestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelRequestLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneRequest, javax.swing.GroupLayout.DEFAULT_SIZE, 361, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanelRequestLayout.setVerticalGroup(
            jPanelRequestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelRequestLayout.createSequentialGroup()
                .addComponent(jScrollPaneRequest, javax.swing.GroupLayout.DEFAULT_SIZE, 459, Short.MAX_VALUE)
                .addContainerGap())
        );

        jButtonPlay.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPlayActionPerformed(evt);
            }
        });

        jPanelResponse.setBorder(javax.swing.BorderFactory.createTitledBorder("Response:"));

        jScrollPaneResponse.setViewportView(jEditorPaneResponse);

        javax.swing.GroupLayout jPanelResponseLayout = new javax.swing.GroupLayout(jPanelResponse);
        jPanelResponse.setLayout(jPanelResponseLayout);
        jPanelResponseLayout.setHorizontalGroup(
            jPanelResponseLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelResponseLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneResponse, javax.swing.GroupLayout.DEFAULT_SIZE, 356, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanelResponseLayout.setVerticalGroup(
            jPanelResponseLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelResponseLayout.createSequentialGroup()
                .addComponent(jScrollPaneResponse, javax.swing.GroupLayout.DEFAULT_SIZE, 459, Short.MAX_VALUE)
                .addContainerGap())
        );

        jLabelChooseOperation.setText("Choose operation:");

        jListOperation.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jListOperation.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListOperationMouseClicked(evt);
            }
        });
        jScrollPaneOperation.setViewportView(jListOperation);

        jLabelImage.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);

        javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
        jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 1198, Short.MAX_VALUE)
            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelMainLayout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                        .addComponent(jLabelImage, javax.swing.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE)
                        .addComponent(jLabelChooseOperation, javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(jScrollPaneOperation, javax.swing.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanelMainLayout.createSequentialGroup()
                            .addComponent(jPanelRequest, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jButtonPlay, javax.swing.GroupLayout.PREFERRED_SIZE, 94, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                            .addComponent(jPanelResponse, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGroup(jPanelMainLayout.createSequentialGroup()
                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup()
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 237, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabelSendTo)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                    .addComponent(jTextFieldSendTo, javax.swing.GroupLayout.PREFERRED_SIZE, 511, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGroup(jPanelMainLayout.createSequentialGroup()
                                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(jLabelServiceQName)
                                        .addGroup(jPanelMainLayout.createSequentialGroup()
                                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addComponent(jLabelInterfaceQName)
                                                .addComponent(jLabelEndpointName)
                                                .addComponent(jLabelOperationName))
                                            .addGap(18, 18, 18)
                                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                                .addComponent(jTextFieldOperationName, javax.swing.GroupLayout.DEFAULT_SIZE, 340, Short.MAX_VALUE)
                                                .addComponent(jTextFieldEndpointName, javax.swing.GroupLayout.DEFAULT_SIZE, 490, Short.MAX_VALUE)
                                                .addComponent(jTextFieldInterfaceQName, javax.swing.GroupLayout.Alignment.LEADING)
                                                .addComponent(jTextFieldServiceQName, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 490, javax.swing.GroupLayout.PREFERRED_SIZE))))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 204, Short.MAX_VALUE)))
                            .addGap(106, 106, 106)))
                    .addContainerGap()))
        );
        jPanelMainLayout.setVerticalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 658, Short.MAX_VALUE)
            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelMainLayout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabelServiceQName)
                        .addComponent(jTextFieldServiceQName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jLabelChooseOperation))
                    .addGap(7, 7, 7)
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addGroup(jPanelMainLayout.createSequentialGroup()
                            .addComponent(jScrollPaneOperation, javax.swing.GroupLayout.PREFERRED_SIZE, 387, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jLabelImage, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGroup(jPanelMainLayout.createSequentialGroup()
                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                .addComponent(jLabelInterfaceQName)
                                .addComponent(jTextFieldInterfaceQName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                .addComponent(jLabelEndpointName)
                                .addComponent(jTextFieldEndpointName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                .addComponent(jLabelOperationName)
                                .addComponent(jTextFieldOperationName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                .addComponent(jTextFieldSendTo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jLabelSendTo))
                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(jPanelMainLayout.createSequentialGroup()
                                    .addGap(264, 264, 264)
                                    .addComponent(jButtonPlay, javax.swing.GroupLayout.PREFERRED_SIZE, 78, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGroup(jPanelMainLayout.createSequentialGroup()
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                        .addComponent(jPanelResponse, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(jPanelRequest, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))))
                    .addContainerGap(14, Short.MAX_VALUE)))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(0, 0, Short.MAX_VALUE)
                .addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(0, 0, Short.MAX_VALUE)
                .addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

	private void jButtonPlayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPlayActionPerformed
		if(this.jListOperation.getSelectedValue() != null) {
			ThreadMsgSender sender = new ThreadMsgSender((MockOperation) this.jListOperation.getSelectedValue(), this.jLabelImage, this.jEditorPaneRequest, this.jEditorPaneResponse, this.jTextFieldSendTo.getText(), this.client);
			sender.start();
		}
	}//GEN-LAST:event_jButtonPlayActionPerformed

	private void jListOperationMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListOperationMouseClicked
		if(this.jListOperation.getSelectedValue() != null) {
			MockOperation op = (MockOperation) this.jListOperation.getSelectedValue();
			this.jTextFieldOperationName.setText(op.getName());
			this.jEditorPaneRequest.setText(op.getRequest());
		}
	}//GEN-LAST:event_jListOperationMouseClicked

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new CallWebServiceFrame(null, null).setVisible(true);
			}
		});
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonPlay;
    private javax.swing.JEditorPane jEditorPaneRequest;
    private javax.swing.JEditorPane jEditorPaneResponse;
    private javax.swing.JLabel jLabelChooseOperation;
    private javax.swing.JLabel jLabelEndpointName;
    private javax.swing.JLabel jLabelImage;
    private javax.swing.JLabel jLabelInterfaceQName;
    private javax.swing.JLabel jLabelOperationName;
    private javax.swing.JLabel jLabelSendTo;
    private javax.swing.JLabel jLabelServiceQName;
    private javax.swing.JList jListOperation;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JPanel jPanelRequest;
    private javax.swing.JPanel jPanelResponse;
    private javax.swing.JScrollPane jScrollPaneOperation;
    private javax.swing.JScrollPane jScrollPaneRequest;
    private javax.swing.JScrollPane jScrollPaneResponse;
    private javax.swing.JTextField jTextFieldEndpointName;
    private javax.swing.JTextField jTextFieldInterfaceQName;
    private javax.swing.JTextField jTextFieldOperationName;
    private javax.swing.JTextField jTextFieldSendTo;
    private javax.swing.JTextField jTextFieldServiceQName;
    // End of variables declaration//GEN-END:variables

}
