/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AddNeighBourNodeFrame.java
 *
 * Created on 20 mars 2011, 15:48:08
 */

package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Toolkit;

import javax.swing.JOptionPane;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.topology.EsbG;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;

/**
 *
 * @author nsalatge
 */
public class BindWSToNodeFrame extends javax.swing.JFrame {

	private WSOUIClient client;
	private Registry registry;
	
	private MockEndpoint wsToBind = null;
	private Node selectedNode = null;
	
    /** Creates new form AddNeighBourNodeFrame */
    public BindWSToNodeFrame(WSOUIClient client, MockEndpoint nodeToAdd) {
        initComponents();
        if(client != null) {
			this.jPanelMain.setBackground(client.getColor());
		}
        
        this.wsToBind = nodeToAdd;
        this.setTitle("Bind " + this.wsToBind.getName() + " to node");
		this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
		
		
		this.client = client;
		this.registry = client.getRegistry();

		this.jListNeighbourNodes.setModel(new NodeListModel(this.registry.getEsbNodes()));
		this.jLabelToValue.setText(this.wsToBind.getName());
		
		this.setLocation();
    }
    
    
	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
	}
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelMain = new javax.swing.JPanel();
        jLabelPossibleNeighbourNodes = new javax.swing.JLabel();
        jScrollPaneListNeighBourNode = new javax.swing.JScrollPane();
        jListNeighbourNodes = new javax.swing.JList();
        jLabelNodeSelected = new javax.swing.JLabel();
        jLabelNodeValue = new javax.swing.JLabel();
        jButtonOK = new javax.swing.JButton();
        jLabelTo = new javax.swing.JLabel();
        jLabelToValue = new javax.swing.JLabel();

        jLabelPossibleNeighbourNodes.setText("Possible nodes to add:");

        jListNeighbourNodes.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jListNeighbourNodes.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListNeighbourNodesMouseClicked(evt);
            }
        });
        jScrollPaneListNeighBourNode.setViewportView(jListNeighbourNodes);

        jLabelNodeSelected.setText("Add Node selected:");

        jButtonOK.setText("Add");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jLabelTo.setText("to:");

        javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
        jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 489, Short.MAX_VALUE)
            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelMainLayout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanelMainLayout.createSequentialGroup()
                            .addComponent(jScrollPaneListNeighBourNode, javax.swing.GroupLayout.PREFERRED_SIZE, 240, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(jPanelMainLayout.createSequentialGroup()
                                    .addGap(18, 18, 18)
                                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                        .addComponent(jLabelNodeSelected, javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(jButtonOK)))
                                .addGroup(jPanelMainLayout.createSequentialGroup()
                                    .addGap(28, 28, 28)
                                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(jLabelNodeValue, javax.swing.GroupLayout.DEFAULT_SIZE, 201, Short.MAX_VALUE)
                                        .addGroup(jPanelMainLayout.createSequentialGroup()
                                            .addGap(10, 10, 10)
                                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addGroup(jPanelMainLayout.createSequentialGroup()
                                                    .addGap(10, 10, 10)
                                                    .addComponent(jLabelToValue, javax.swing.GroupLayout.DEFAULT_SIZE, 181, Short.MAX_VALUE))
                                                .addComponent(jLabelTo)))))))
                        .addComponent(jLabelPossibleNeighbourNodes))
                    .addContainerGap()))
        );
        jPanelMainLayout.setVerticalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 320, Short.MAX_VALUE)
            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelMainLayout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addGroup(jPanelMainLayout.createSequentialGroup()
                            .addComponent(jLabelPossibleNeighbourNodes)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jScrollPaneListNeighBourNode, javax.swing.GroupLayout.PREFERRED_SIZE, 278, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGroup(jPanelMainLayout.createSequentialGroup()
                            .addGap(63, 63, 63)
                            .addComponent(jLabelNodeSelected)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jLabelNodeValue, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jLabelTo)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jLabelToValue)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButtonOK)))
                    .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(0, 0, Short.MAX_VALUE)
                .addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(0, 0, Short.MAX_VALUE)
                .addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        try {
			this.registry.bindWebServiceToNode(this.wsToBind, this.selectedNode);
			this.client.refreshAll();
			this.setVisible(false);
		} catch (WSOUIClientException e) {
			e.printStackTrace();
        	JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"Add node Interrupted", JOptionPane.ERROR_MESSAGE);
		} catch (ESBException e) {
		    e.printStackTrace();
            JOptionPane.showMessageDialog(this,
                    e.getMessage(), 
                    "Add node Interrupted", JOptionPane.ERROR_MESSAGE);
        } 
    }//GEN-LAST:event_jButtonOKActionPerformed

    private void jListNeighbourNodesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListNeighbourNodesMouseClicked
        this.selectedNode = (Node) this.jListNeighbourNodes.getSelectedValue();
        this.jLabelNodeValue.setText(this.selectedNode.getQName().getLocalPart());
    }//GEN-LAST:event_jListNeighbourNodesMouseClicked

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new BindWSToNodeFrame(null, null).setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonOK;
    private javax.swing.JLabel jLabelNodeSelected;
    private javax.swing.JLabel jLabelNodeValue;
    private javax.swing.JLabel jLabelPossibleNeighbourNodes;
    private javax.swing.JLabel jLabelTo;
    private javax.swing.JLabel jLabelToValue;
    private javax.swing.JList jListNeighbourNodes;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JScrollPane jScrollPaneListNeighBourNode;
    // End of variables declaration//GEN-END:variables

}
