/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.petalslink.easiestdemo.client.model.impl.ws;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPMessageGenerator;





/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class MockServiceImpl implements MockService {


	private Service service;
	private List<MockEndpoint> endpoints = new ArrayList<MockEndpoint>();
	private SOAPMessageGenerator msgGenerator = null;
	

	public MockServiceImpl(Service service) throws SOAPException  {
		this.service = service;
		this.msgGenerator = new SOAPMessageGenerator(this.service.getDescription());
		for(Endpoint ep: this.service.getEndpoints()) {
			this.endpoints.add(new MockEndpointImpl(this, ep));
		}
	}


	@Override
	public QName getQName() {
		return this.service.getQName();
	}

	@Override
	public List<MockEndpoint> getEndpoints() {
		return this.endpoints;
	}


	@Override
	public SOAPMessageGenerator getSOAPMessageGenerator() {
		return this.msgGenerator;
	}


	@Override
	public Description getDescription() {
		return this.service.getDescription();
	}
	
	public String toString() {
		return this.service.getQName().toString();
	}

}
