package org.petalslink.easiestdemo.client.model.api;

import java.net.URL;
import java.util.List;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.Endpoint;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.gov.GovNode;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.petalslink.easiergov.GovException;

public interface Registry {

	List<Node> getAllNodes();
	
	List<Node> getEsbNodes();
	
	List<Node> getMonitoringNodes();
	
	List<MockService> getWebServices();
	
	GovNode getGovNode();
	
	void addDescriptionOfWebServices(Description... desc) throws SOAPException;
	
	Node addDescriptionOfAdminEsbNode(Description... desc) throws SOAPException;

	List<Description> getDescriptionsOfWebServices();
	
	List<Description> getDescriptionsOfAdminESBNodes();

	List<ClientEndpointProxy> getAllClientEndpointProxy();

	List<MockEndpoint> getAllWebServicesPartnerEndpoint();

	Node addNewAdminWsdlofESBNode(URL... urls) throws WSOUIClientException;

	void addNewWsdlofWebServices(URL... urls) throws WSOUIClientException;


	void addNeighBourNode(Node source, Node target) throws WSOUIClientException;

	Node findNodeByAdminUrl(URL adminUrl) throws WSOUIClientException;

	void moveEndpointToNode(Endpoint endpoint, Node targetNode,
			boolean addConnection) throws WSOUIClientException;

	Document getStateOfNode(Node node) throws WSOUIClientException;

	void deployBpel(Node source, URL bpel) throws WSOUIClientException;

	void createNode(String nodeName, String nodeNameSpace, String host,
			String port, String soapPort, boolean monitoring)
			throws WSOUIClientException;

	void connectMonitoringToEsb(Node model, Node selectedNode) throws WSOUIClientException;

    void importGovernance(String adminManagerAddress) throws SOAPException;

    void createGovernance(String text, String text2, String text3, String text4) throws GovException;

    void bindWebServiceToNode(MockEndpoint wsToBind, Node selectedNode) throws ESBException;

	void refreshConnectionBetweenFramework() throws WSOUIClientException;
}
