package org.petalslink.easiestdemo.client.model.impl.gov;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.model.impl.ws.MockServiceImpl;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;

public class ProvidedServiceImpl implements ProvidedService {

    
    private QName name;
    private MockService mockService;
    private MockEndpoint mockEndpoint;
    private Service service;
    private Endpoint endpoint;
    
    public ProvidedServiceImpl(QName qName, Endpoint endpoint, Service service) throws SOAPException {
        this.name = qName;
        this.endpoint = endpoint;
        this.service = service;
        
        this.mockService = new MockServiceImpl(service);
        
        for(MockEndpoint ep: this.mockService.getEndpoints()) {
            if(ep.getName().equals(endpoint.getName())) {
                this.mockEndpoint = ep;
                break;
            }
        }
        
    }
    
    @Override
    public MockService getService() {
        return mockService;
    }

    @Override
    public MockEndpoint getEndpoint() {
        return mockEndpoint;
    }

    public String getAddress() {
        return this.endpoint.getAddress();
    }
    
    
    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public Node getNode() {
        throw new UnsupportedOperationException();
    }



}
