/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * FilterFrame.java
 *
 * Created on 8 avr. 2011, 22:28:13
 */

package org.petalslink.easiestdemo.client.notification;

import java.awt.Toolkit;
import java.util.Calendar;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType;


/**
 *
 * @author nsalatge
 */
public class FilterFrame extends javax.swing.JFrame {

	/** Creates new form FilterFrame 
	 * @param notifyGui */
	public FilterFrame(WSOUIClient client, NotifyGui notifyGui) {
		initComponents();
		if(client != null) {
			this.jPanelMain.setBackground(client.getColor());
		}
		this.setTitle("Filter notification");
		if(notifyGui != null) {
			if(notifyGui.getNotify() != null && notifyGui.getNotify().getNotificationMessage() != null &&
					notifyGui.getNotify().getNotificationMessage().size() > 0) {
				NotificationMessageHolderType nmht = notifyGui.getNotify().getNotificationMessage().get(0);
				Element elmt = (Element) nmht.getMessage().getAny();

				try {
					if(elmt.getLocalName().equals("OperationMetrics")) {
						Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
						doc.appendChild(doc.importNode(elmt, true));
						OperationMetrics op = SOAUtil.getInstance().getReader(EasiestDEMOFramework.getInstance()).get().readDocument(doc, OperationMetrics.class);

						String msg = "";
						msg = msg + "Operation name: " + QName.valueOf(op.getOperationName()).getLocalPart() + "\n";
						msg = msg + "Interface name: " + op.getPortType() + "\n";
						msg = msg + "Metrics: " + "\n";
						msg = msg + "\tAverage latency:               " + op.getServiceTime().getDuration().getTimeInMillis(Calendar.getInstance()) + "\n";
						msg = msg + "\tLast response time:            " + op.getLastResponseTime().getDuration().getTimeInMillis(Calendar.getInstance()) + "\n";
						msg = msg + "\tMaximum response time:         " + op.getMaxResponseTime().getDuration().getTimeInMillis(Calendar.getInstance()) + "\n";
						msg = msg + "\tNumber of requests:            " + op.getNumberOfRequests().getValue() + "\n";
						msg = msg + "\tNumber of successful requests: " + op.getNumberOfSuccessfulRequests().getValue() + "\n";
						msg = msg + "\tNumber of failed requests:     " + op.getNumberOfFailedRequests().getValue() + "\n";
						msg = msg + "\tLast request size:             " + op.getLastRequestSize().getValue() + "\n";
						msg = msg + "\tMaximum request size:          " + op.getMaxRequestSize().getValue() + "\n";
						msg = msg + "\tLast response size:            " + op.getLastResponseSize().getValue() + "\n";
						msg = msg + "\tMaximum response size:         " + op.getMaxResponseSize().getValue() + "\n";
						
						
						this.jTextArea.setText(msg);
						this.jLabelIdentification.setText("Notification identified as WSDM operation metric");
					}
				} catch (ParserConfigurationException e) {
					this.jLabelIdentification.setText("Notification not identified");
					this.jTextArea.setText(e.getMessage());
				} catch (XmlObjectReadException e) {
					this.jLabelIdentification.setText("Notification not identified");
					this.jTextArea.setText(e.getMessage());
				}
			}
		}

		this.setLocation();
	}

	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		jPanelMain = new javax.swing.JPanel();
		jLabelFilter = new javax.swing.JLabel();
		jLabelIdentification = new javax.swing.JLabel();
		jScrollPaneText = new javax.swing.JScrollPane();
		jTextArea = new javax.swing.JTextArea();

		jLabelFilter.setText("Filter:");

		jTextArea.setColumns(20);
		jTextArea.setRows(5);
		jScrollPaneText.setViewportView(jTextArea);

		javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
		jPanelMain.setLayout(jPanelMainLayout);
		jPanelMainLayout.setHorizontalGroup(
				jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 562, Short.MAX_VALUE)
				.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
						.addGroup(jPanelMainLayout.createSequentialGroup()
								.addContainerGap()
								.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
										.addComponent(jScrollPaneText, javax.swing.GroupLayout.DEFAULT_SIZE, 542, Short.MAX_VALUE)
										.addGroup(jPanelMainLayout.createSequentialGroup()
												.addComponent(jLabelFilter)
												.addGap(18, 18, 18)
												.addComponent(jLabelIdentification, javax.swing.GroupLayout.DEFAULT_SIZE, 496, Short.MAX_VALUE)))
												.addContainerGap()))
		);
		jPanelMainLayout.setVerticalGroup(
				jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 377, Short.MAX_VALUE)
				.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
						.addGroup(jPanelMainLayout.createSequentialGroup()
								.addContainerGap()
								.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
										.addComponent(jLabelFilter)
										.addComponent(jLabelIdentification, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
										.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
										.addComponent(jScrollPaneText, javax.swing.GroupLayout.PREFERRED_SIZE, 330, javax.swing.GroupLayout.PREFERRED_SIZE)
										.addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
		);

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
		getContentPane().setLayout(layout);
		layout.setHorizontalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addGap(0, 0, Short.MAX_VALUE)
						.addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addGap(0, 0, Short.MAX_VALUE))
		);
		layout.setVerticalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addGap(0, 0, Short.MAX_VALUE)
						.addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addGap(0, 0, Short.MAX_VALUE))
		);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new FilterFrame(null, null).setVisible(true);
			}
		});
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JLabel jLabelFilter;
	private javax.swing.JLabel jLabelIdentification;
	private javax.swing.JPanel jPanelMain;
	private javax.swing.JScrollPane jScrollPaneText;
	private javax.swing.JTextArea jTextArea;
	// End of variables declaration//GEN-END:variables

}
