/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.petalslink.easiestdemo.client.gui.Property;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.topology.ExternalEndpointG;
import org.petalslink.easiestdemo.client.topology.TopologyView;

public class ExternalProviderEndpointG
extends ExternalEndpointG {
    public static int DEFAULT_SIZE = 30;
    private MockEndpoint model;
    private Image img = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/topology/provider.png")).getImage();

    public ExternalProviderEndpointG(TopologyView topology, MockEndpoint endpoint, int x, int y) {
        super(topology);
        this.model = endpoint;
        this.color = Color.green;
        this.size = DEFAULT_SIZE;
        this.init();
        this.setLocation(x, y);
        this.properties.add(new Property("name", this.getQName().getLocalPart()));
        this.properties.add(new Property("namespace", this.getQName().getNamespaceURI()));
        this.properties.add(new Property("wsdl url", this.getMockEndpoint().getService().getDescription().getDocumentBaseURI()));
    }

    @Override
    public QName getQName() {
        return new QName(this.model.getService().getQName().getNamespaceURI(), this.model.getName());
    }

    @Override
    public void update(Graphics g) {
        super.update(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.img, (int)this.circle.getCenterX() + this.size / 2, (int)this.circle.getCenterY() - this.img.getHeight(null) / 2 - this.size / 2, null);
        g2.setColor(Color.black);
        g2.drawString(this.getQName().getLocalPart(), (int)this.circle.getCenterX() - this.size / 2, (int)this.circle.getCenterY() + this.size);
    }

    @Override
    public MockEndpoint getMockEndpoint() {
        return this.model;
    }
}

