/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.petalslink.easiestdemo.client.topology.menu.action.NodeListModel;

public class AddNeighBourNodeFrame
extends JFrame {
    private WSOUIClient client;
    private Registry registry;
    private EsbG nodeToAdd = null;
    private Node selectedNode = null;
    private JButton jButtonOK;
    private JLabel jLabelNodeSelected;
    private JLabel jLabelNodeValue;
    private JLabel jLabelPossibleNeighbourNodes;
    private JLabel jLabelTo;
    private JLabel jLabelToValue;
    private JList jListNeighbourNodes;
    private JPanel jPanelMain;
    private JScrollPane jScrollPaneListNeighBourNode;

    public AddNeighBourNodeFrame(WSOUIClient client, EsbG nodeToAdd) {
        this.initComponents();
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.nodeToAdd = nodeToAdd;
        this.setTitle("Add Neighbour Node to " + this.nodeToAdd.getQName().getLocalPart());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
        this.client = client;
        this.registry = client.getRegistry();
        this.jListNeighbourNodes.setModel(new NodeListModel(this.registry.getEsbNodes()));
        this.jLabelToValue.setText(this.nodeToAdd.getQName().getLocalPart());
        this.setLocation();
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabelPossibleNeighbourNodes = new JLabel();
        this.jScrollPaneListNeighBourNode = new JScrollPane();
        this.jListNeighbourNodes = new JList();
        this.jLabelNodeSelected = new JLabel();
        this.jLabelNodeValue = new JLabel();
        this.jButtonOK = new JButton();
        this.jLabelTo = new JLabel();
        this.jLabelToValue = new JLabel();
        this.jLabelPossibleNeighbourNodes.setText("Possible nodes to connect:");
        this.jListNeighbourNodes.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListNeighbourNodes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AddNeighBourNodeFrame.this.jListNeighbourNodesMouseClicked(evt);
            }
        });
        this.jScrollPaneListNeighBourNode.setViewportView(this.jListNeighbourNodes);
        this.jLabelNodeSelected.setText("Add WS selected:");
        this.jButtonOK.setText("Add");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddNeighBourNodeFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelTo.setText("to node:");
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 489, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jScrollPaneListNeighBourNode, -2, 240, -2).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelNodeSelected, GroupLayout.Alignment.LEADING).addComponent(this.jButtonOK))).addGroup(jPanelMainLayout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelNodeValue, -1, 201, Short.MAX_VALUE).addGroup(jPanelMainLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelToValue, -1, 181, Short.MAX_VALUE)).addComponent(this.jLabelTo))))))).addComponent(this.jLabelPossibleNeighbourNodes)).addContainerGap())));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 320, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jLabelPossibleNeighbourNodes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneListNeighBourNode, -2, 278, -2)).addGroup(jPanelMainLayout.createSequentialGroup().addGap(63, 63, 63).addComponent(this.jLabelNodeSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNodeValue, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelToValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK))).addContainerGap(-1, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.registry.addNeighBourNode(this.nodeToAdd.getModel(), this.selectedNode);
            this.client.refreshAll();
            this.setVisible(false);
        }
        catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Add Neighbour node Interrupted", 0);
        }
    }

    private void jListNeighbourNodesMouseClicked(MouseEvent evt) {
        this.selectedNode = (Node)this.jListNeighbourNodes.getSelectedValue();
        this.jLabelNodeValue.setText(this.selectedNode.getQName().getLocalPart());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AddNeighBourNodeFrame(null, null).setVisible(true);
            }
        });
    }
}

