package org.petalslink.easiestdemo.client.model.api.esb;

import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easierbsm.admin.client.api.BSMAdminClient;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbNodeType;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;


public interface Node {

	public QName getQName();
	
	public Description getAdministrationServiceDescription();
	
	public List<QName> getNeighbourNodeNames();
	
	public List<ProviderEndpoint> getProviderEndpoints();

	public List<ProviderEndpointProxy> getProviderEndpointProxies();

	public List<ClientEndpointProxy> getClientEndpointProxies();

	com.ebmwebsourcing.easyesb.soa.api.node.Node getModel();

	void setModel(com.ebmwebsourcing.easyesb.soa.api.node.Node model);

	EJaxbBasicNodeInformationsType getBasicInfos();

	void setBasicInfos(EJaxbBasicNodeInformationsType basicInfos);

	Document getStateOfNode() throws SOAPException;
	
	boolean isMonitoringNode();
	
	void setMonitoringNode(boolean monitoring);

	List<Node> getMonitoredNodes() throws WSOUIClientException;

	AdminClient getAdminClient();
	
	BSMAdminClient getBSMAdminClient();

	void refreshMonitoredNodes() throws WSOUIClientException;

	void analyzeState(EJaxbNodeType node) throws WSOUIClientException;
}
