/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.petalslink.easiestdemo.client.topology.menu;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.util.logging.Logger;

import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.petalslink.easiestdemo.client.topology.ExternalClientEndpointG;
import org.petalslink.easiestdemo.client.topology.ExternalProviderEndpointG;
import org.petalslink.easiestdemo.client.topology.InternalClientProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.InternalProviderProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.menu.action.AddNeighBourNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.BindWSToNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.CallWebServiceFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.ConnectMonitoring2EsbFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.CreateGovFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.CreateNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.GetStateFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.ImportGovFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.ImportNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.MoveEndpointToNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.StoreBpelFrame;

import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.Constants;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.petalslink.easycommons.explorer.ExplorerFrame;

import easybox.easyesb.petalslink.com.admin.model.datatype._1.EJaxbPropertyType;
import easyesb.petalslink.com.data.admin._1.AddProperties;
import esstar.petalslink.com.service.management._1_0.ManagementException;

/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class MenuMouseTopology extends JPopupMenu {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 1L;


    private static Logger LOG = Logger.getLogger(MenuMouseTopology.class.getName());


    private javax.swing.JMenuItem jMenuItemCreateNode;
    private javax.swing.JMenuItem jMenuItemImportNode;
    private javax.swing.JMenuItem jMenuItemCreateMonitoring;
    private javax.swing.JMenuItem jMenuItemImportMonitoring;
    private javax.swing.JMenuItem jMenuItemCreateGov;
    private javax.swing.JMenuItem jMenuItemImportGov;
    private javax.swing.JMenuItem jMenuItemStoreBpel;
    private javax.swing.JMenuItem jMenuItemBindWSToNode;
    private javax.swing.JMenuItem jMenuItemMoveEndpointToNode;
    private javax.swing.JMenuItem jMenuItemAddNeighBourNode;
    private javax.swing.JMenuItem jMenuItemGetStateNode;
    private javax.swing.JMenuItem jMenuItemCallWebService;
    private javax.swing.JMenuItem jMenuItemExploreNode;
    private javax.swing.JMenuItem jMenuItemRefresh;
    private javax.swing.JMenuItem jMenuItemStopSynchronization;

    private WSOUIClient client;
    private Registry registry;

    private EsbG esbSelected = null;
    private InternalProviderProxyEndpointG internalProviderProxyEndpointSelected = null;
    private InternalClientProxyEndpointG internalClientProxyEndpointSelected = null;
    private ExternalProviderEndpointG externalProviderEndpointSelected = null;
    private ExternalClientEndpointG externalClientEndpointSelected = null;

    /** Creates a new instance of MenuMouse */
    public MenuMouseTopology(WSOUIClient client) {
        this.initComponents();

        this.client = client;
        this.registry = this.client.getRegistry();
    }

    public void setSelectedItem(Object item) {
        esbSelected = null;
        internalProviderProxyEndpointSelected = null;
        internalClientProxyEndpointSelected = null;
        externalProviderEndpointSelected = null;
        externalClientEndpointSelected = null;

        if(item instanceof EsbG) {
            this.esbSelected = (EsbG)item;
        } else if(item instanceof InternalProviderProxyEndpointG) {
            this.internalProviderProxyEndpointSelected = (InternalProviderProxyEndpointG)item;
        } else if(item instanceof InternalClientProxyEndpointG) {
            this.internalClientProxyEndpointSelected = (InternalClientProxyEndpointG)item;
        } else if(item instanceof ExternalProviderEndpointG) {
            this.externalProviderEndpointSelected = (ExternalProviderEndpointG)item;
        } else if(item instanceof ExternalClientEndpointG) {
            this.externalClientEndpointSelected = (ExternalClientEndpointG)item;
        } 

        this.refresh();
    }

    public void refresh() {
        this.jMenuItemCreateNode.setEnabled(false);
        this.jMenuItemImportNode.setEnabled(false);
        this.jMenuItemCreateGov.setEnabled(false);
        this.jMenuItemImportGov.setEnabled(false);
        this.jMenuItemStoreBpel.setEnabled(false);
        this.jMenuItemBindWSToNode.setEnabled(false);
        this.jMenuItemMoveEndpointToNode.setEnabled(false);
        this.jMenuItemAddNeighBourNode.setEnabled(false);
        this.jMenuItemGetStateNode.setEnabled(false);
        this.jMenuItemCallWebService.setEnabled(false);
        this.jMenuItemExploreNode.setEnabled(false);
        this.jMenuItemRefresh.setEnabled(false);
        this.jMenuItemStopSynchronization.setEnabled(false);

        if(esbSelected != null) {
            this.jMenuItemStoreBpel.setEnabled(true);
            this.jMenuItemAddNeighBourNode.setEnabled(true);
            this.jMenuItemGetStateNode.setEnabled(true);
            this.jMenuItemExploreNode.setEnabled(true);
            this.jMenuItemRefresh.setEnabled(true);
            if(esbSelected.getModel().isMonitoringNode()) {
                this.jMenuItemStopSynchronization.setEnabled(true);
            }
        } else if(this.internalProviderProxyEndpointSelected != null) {
            this.jMenuItemMoveEndpointToNode.setEnabled(true);
        } else if(this.internalClientProxyEndpointSelected != null) {
            this.jMenuItemMoveEndpointToNode.setEnabled(true);
        } else if(this.externalProviderEndpointSelected != null) {
            this.jMenuItemCallWebService.setEnabled(true);
            this.jMenuItemBindWSToNode.setEnabled(true);
        } else if(this.externalClientEndpointSelected != null) {
            this.jMenuItemCallWebService.setEnabled(true);
        } else if(this.registry.getGovNode() == null) { 
            this.jMenuItemCreateGov.setEnabled(true);
            this.jMenuItemImportGov.setEnabled(true);
            this.jMenuItemCreateNode.setEnabled(true);
            this.jMenuItemImportNode.setEnabled(true);
            this.jMenuItemCreateMonitoring.setEnabled(true);
            this.jMenuItemImportMonitoring.setEnabled(true);
        } else {
            this.jMenuItemCreateNode.setEnabled(true);
            this.jMenuItemImportNode.setEnabled(true);
            this.jMenuItemCreateMonitoring.setEnabled(true);
            this.jMenuItemImportMonitoring.setEnabled(true);
        }

    }

    private void initComponents() {
        this.jMenuItemCreateNode = new javax.swing.JMenuItem();
        this.jMenuItemImportNode = new javax.swing.JMenuItem();
        this.jMenuItemCreateMonitoring = new javax.swing.JMenuItem();
        this.jMenuItemImportMonitoring = new javax.swing.JMenuItem();
        this.jMenuItemCreateGov = new javax.swing.JMenuItem();
        this.jMenuItemImportGov = new javax.swing.JMenuItem();
        this.jMenuItemStoreBpel = new javax.swing.JMenuItem();
        this.jMenuItemBindWSToNode = new javax.swing.JMenuItem();
        this.jMenuItemMoveEndpointToNode = new javax.swing.JMenuItem();
        this.jMenuItemAddNeighBourNode = new javax.swing.JMenuItem();
        this.jMenuItemGetStateNode = new javax.swing.JMenuItem();
        this.jMenuItemCallWebService = new javax.swing.JMenuItem();
        this.jMenuItemExploreNode = new javax.swing.JMenuItem();
        this.jMenuItemRefresh = new javax.swing.JMenuItem();
        this.jMenuItemStopSynchronization = new javax.swing.JMenuItem();


        this.setComponentPopupMenu(this);

        this.jMenuItemCreateNode.setText("Create Node");
        this.jMenuItemCreateNode
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemCreateNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemCreateNode);


        this.jMenuItemImportNode.setText("Import Node");
        this.jMenuItemImportNode
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemImportNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemImportNode);
        
        
        this.jMenuItemCreateMonitoring.setText("Create Monitoring");
        this.jMenuItemCreateMonitoring
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemCreateMonitoringActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemCreateMonitoring);


        this.jMenuItemImportMonitoring.setText("Import Monitoring");
        this.jMenuItemImportMonitoring
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemImportMonitoringActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemImportMonitoring);


        this.jMenuItemCreateGov.setText("Create Governance");
        this.jMenuItemCreateGov
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemCreateGovActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemCreateGov);


        this.jMenuItemImportGov.setText("Import Governance");
        this.jMenuItemImportGov
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemImportGovActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemImportGov);


        this.jMenuItemStoreBpel.setText("Store Bpel");
        this.jMenuItemStoreBpel
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemStoreBpelActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemStoreBpel);

        
        this.jMenuItemBindWSToNode.setText("Bind Web Service to Node");
        this.jMenuItemBindWSToNode
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemBindWSToNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemBindWSToNode);



        this.jMenuItemMoveEndpointToNode.setText("Move Endpoint to Node");
        this.jMenuItemMoveEndpointToNode
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemMoveEndpointToNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemMoveEndpointToNode);


        this.jMenuItemAddNeighBourNode.setText("Add NeighBour Node");
        this.jMenuItemAddNeighBourNode
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemAddNeighBourNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemAddNeighBourNode);

        this.jMenuItemGetStateNode.setText("Get State of Node");
        this.jMenuItemGetStateNode
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemGetStateNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemGetStateNode);


        this.jMenuItemCallWebService.setText("Call Web Service");
        this.jMenuItemCallWebService
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemCallWebServiceActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemCallWebService);

        this.jMenuItemExploreNode.setText("Explore Node");
        this.jMenuItemExploreNode
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemExploreNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemExploreNode);




        this.jMenuItemRefresh.setText("Refresh node");
        this.jMenuItemRefresh
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemRefresh);

        this.jMenuItemStopSynchronization.setText("Stop synchronization");
        this.jMenuItemStopSynchronization
        .addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(
                    final java.awt.event.ActionEvent evt) {
                MenuMouseTopology.this
                .jMenuItemStopSynchronizationActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemStopSynchronization);
    }


    protected void jMenuItemBindWSToNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        BindWSToNodeFrame bindWS = new BindWSToNodeFrame(this.client, this.externalProviderEndpointSelected.getMockEndpoint());
        bindWS.setVisible(true);
    }

    protected void jMenuItemImportGovActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        ImportGovFrame importGov = new ImportGovFrame(this.client);
        importGov.setVisible(true);
    }

    protected void jMenuItemCreateGovActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        CreateGovFrame createGov = new CreateGovFrame(this.client);
        createGov.setVisible(true);
    }

    protected void jMenuItemStopSynchronizationActionPerformed(ActionEvent evt) {
        try {
            this.setVisible(false);

            // add properties on monitoring node
            AdminClient monitoringClient = new AdminClientImpl(this.esbSelected.getModel().getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString());
            AddProperties monitoringProperties = new AddProperties();
            EJaxbPropertyType esbConnexionProperty = new EJaxbPropertyType();
            esbConnexionProperty.setKey(Constants.ESB_CONNEXION_PROPERTY);
            esbConnexionProperty.setValue("");
            monitoringProperties.getProperty().add(esbConnexionProperty);
            monitoringClient.addProperties(monitoringProperties);

        } catch (MalformedURLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this,
                    e.getMessage(), 
                    "Explore Node Interrupted", JOptionPane.ERROR_MESSAGE);
        } catch (ManagementException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this,
                    e.getMessage(), 
                    "Explore Node Interrupted", JOptionPane.ERROR_MESSAGE);
        }
    }

    protected void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        try {
            this.setVisible(false);
            this.registry.getStateOfNode(this.esbSelected.getModel());
            this.client.refreshAll();
        } catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this,
                    e.getMessage(), 
                    "Explore Node Interrupted", JOptionPane.ERROR_MESSAGE);
        }

    }

    protected void jMenuItemConnectMonitoringToEsbNodeActionPerformed(
            ActionEvent evt) {
        this.setVisible(false);
        ConnectMonitoring2EsbFrame connectMonitoring = new ConnectMonitoring2EsbFrame(this.client, this.esbSelected);
        connectMonitoring.setVisible(true);
    }

    protected void jMenuItemExploreNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        try {
            if(this.esbSelected.getModel().getModel() != null) {
                ExplorerFrame exploreFrame = new ExplorerFrame(this.esbSelected.getModel().getModel().getComponent());
                exploreFrame.setVisible(true);
            } else {
                throw new SCAException("Impossible to explore an imported node, you must create a node");
            }
        } catch (SCAException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this,
                    e.getMessage(), 
                    "Explore Node Interrupted", JOptionPane.ERROR_MESSAGE);
        }
    }

    protected void jMenuItemCallWebServiceActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        CallWebServiceFrame callWebService = new CallWebServiceFrame(this.client, this.externalClientEndpointSelected);
        callWebService.setVisible(true);
    }

    protected void jMenuItemGetStateNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        GetStateFrame getState = new GetStateFrame(this.client, this.esbSelected);
        getState.setVisible(true);
    }



    protected void jMenuItemAddNeighBourNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        AddNeighBourNodeFrame addNeighBourNode = new AddNeighBourNodeFrame(this.client, this.esbSelected);
        addNeighBourNode.setVisible(true);
    }



    private void jMenuItemCreateNodeActionPerformed(
            final java.awt.event.ActionEvent evt) {
        this.setVisible(false);
        CreateNodeFrame createNode = new CreateNodeFrame(this.client, false);
        createNode.setVisible(true);
    }


    private void jMenuItemImportNodeActionPerformed(
            final java.awt.event.ActionEvent evt) {
        this.setVisible(false);
        ImportNodeFrame importNode = new ImportNodeFrame(this.client, false);
        importNode.setVisible(true);
    }
    
    private void jMenuItemCreateMonitoringActionPerformed(
            final java.awt.event.ActionEvent evt) {
        this.setVisible(false);
        CreateNodeFrame createNode = new CreateNodeFrame(this.client, true);
        createNode.setVisible(true);
    }


    private void jMenuItemImportMonitoringActionPerformed(
            final java.awt.event.ActionEvent evt) {
        this.setVisible(false);
        ImportNodeFrame importNode = new ImportNodeFrame(this.client, false);
        importNode.setVisible(true);
    }

    private void jMenuItemStoreBpelActionPerformed(
            final java.awt.event.ActionEvent evt) {
        this.setVisible(false);
        StoreBpelFrame storeBpel = new StoreBpelFrame(this.client, this.esbSelected);
        storeBpel.setVisible(true);
    }

    private void jMenuItemMoveEndpointToNodeActionPerformed(
            final java.awt.event.ActionEvent evt) {
        this.setVisible(false);
        if(this.internalProviderProxyEndpointSelected != null) {
            MoveEndpointToNodeFrame moveEndpointToNode = new MoveEndpointToNodeFrame(this.client, this.internalProviderProxyEndpointSelected);
            moveEndpointToNode.setVisible(true);
        } else if(this.internalClientProxyEndpointSelected != null) {
            MoveEndpointToNodeFrame moveEndpointToNode = new MoveEndpointToNodeFrame(this.client, this.internalClientProxyEndpointSelected);
            moveEndpointToNode.setVisible(true);
        }
    }
}
