/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * CustomizedViewFrame.java
 *
 * Created on 24 avr. 2012, 10:09:04
 */
package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.SpinnerNumberModel;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.topology.RectangleG;

/**
 *
 * @author nsalatge
 */
public class CustomizedViewFrame extends javax.swing.JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private WSOUIClient client;

	/** Creates new form CustomizedViewFrame 
	 * @param wsouiClient */
	public CustomizedViewFrame(WSOUIClient wsouiClient) {
		initComponents();
		this.client = wsouiClient;

		this.setTitle("Customized View");
		this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
		this.setSize(new Dimension(400, 300));

		this.jSliderRectangleWidth.setMinimum(0);
		this.jSliderRectangleWidth.setMaximum(300);
		this.jSliderRectangleWidth.setValue(RectangleG.DEFAULT_WIDTH);

		//Turn on labels at major tick marks.
		this.jSliderRectangleWidth.setMajorTickSpacing(100);
		this.jSliderRectangleWidth.setMinorTickSpacing(10);
		this.jSliderRectangleWidth.setPaintTicks(true);
		this.jSliderRectangleWidth.setPaintLabels(true);

		this.jSliderRectangleHeight.setMinimum(0);
		this.jSliderRectangleHeight.setMaximum(300);
		this.jSliderRectangleHeight.setValue(RectangleG.DEFAULT_WIDTH);

		//Turn on labels at major tick marks.
		this.jSliderRectangleHeight.setMajorTickSpacing(100);
		this.jSliderRectangleHeight.setMinorTickSpacing(10);
		this.jSliderRectangleHeight.setPaintTicks(true);
		this.jSliderRectangleHeight.setPaintLabels(true);
	}

	public boolean showClientEndpoint() {
		return this.jCheckBoxShowClient.isSelected();
	}

	public int getRectangleWidth() {
		return this.jSliderRectangleWidth.getValue();
	}

	public int getRectangleHeight() {
		return this.jSliderRectangleHeight.getValue();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		jCheckBoxShowClient = new javax.swing.JCheckBox();
		jLabelResizeShape = new javax.swing.JLabel();
		jLabelRectangleShape = new javax.swing.JLabel();
		jSliderRectangleWidth = new javax.swing.JSlider();
		jLabelRectangleWidth = new javax.swing.JLabel();
		jLabelRectangleHeight = new javax.swing.JLabel();
		jSliderRectangleHeight = new javax.swing.JSlider();
		jButtonOK = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

		jCheckBoxShowClient.setSelected(true);
		jCheckBoxShowClient.setText("Show client endpoint");
		jCheckBoxShowClient.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jCheckBoxShowClientActionPerformed(evt);
			}
		});

		jLabelResizeShape.setText("Resize shape:");

		jLabelRectangleShape.setText("- Rectangle:");

		jSliderRectangleWidth.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent evt) {
				jSliderRectangleWidthStateChanged(evt);
			}
		});

		jLabelRectangleWidth.setText("width:");

		jLabelRectangleHeight.setText("height:");

		jSliderRectangleHeight.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent evt) {
				jSliderRectangleHeightStateChanged(evt);
			}
		});

		jButtonOK.setText("OK");
		jButtonOK.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonOKActionPerformed(evt);
			}
		});

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
		getContentPane().setLayout(layout);
		layout.setHorizontalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addGroup(layout.createSequentialGroup()
										.addContainerGap()
										.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
												.addComponent(jCheckBoxShowClient)
												.addComponent(jLabelResizeShape)
												.addGroup(layout.createSequentialGroup()
														.addGap(10, 10, 10)
														.addComponent(jLabelRectangleShape))))
														.addGroup(layout.createSequentialGroup()
																.addGap(44, 44, 44)
																.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
																		.addGroup(layout.createSequentialGroup()
																				.addComponent(jLabelRectangleWidth)
																				.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																				.addComponent(jSliderRectangleWidth, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
																				.addGroup(layout.createSequentialGroup()
																						.addComponent(jLabelRectangleHeight)
																						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																						.addComponent(jSliderRectangleHeight, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))))
																						.addContainerGap(14, Short.MAX_VALUE))
																						.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
																								.addContainerGap(239, Short.MAX_VALUE)
																								.addComponent(jButtonOK)
																								.addContainerGap())
				);
		layout.setVerticalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jCheckBoxShowClient)
						.addGap(18, 18, 18)
						.addComponent(jLabelResizeShape)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
						.addComponent(jLabelRectangleShape)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
						.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
								.addComponent(jLabelRectangleWidth, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
								.addComponent(jSliderRectangleWidth, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
								.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
										.addComponent(jLabelRectangleHeight, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
										.addComponent(jSliderRectangleHeight, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
										.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
										.addComponent(jButtonOK)
										.addContainerGap())
				);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jCheckBoxShowClientActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxShowClientActionPerformed
		if(this.client.getTopology() != null) {
			this.client.getTopology().refresh();
		}
	}//GEN-LAST:event_jCheckBoxShowClientActionPerformed

	private void jSliderRectangleWidthStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSliderRectangleWidthStateChanged
		if(this.client.getTopology() != null) {
			this.client.getTopology().refresh();
		}
	}//GEN-LAST:event_jSliderRectangleWidthStateChanged

	private void jSliderRectangleHeightStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSliderRectangleHeightStateChanged
		if(this.client.getTopology() != null) {
			this.client.getTopology().refresh();
		}
	}//GEN-LAST:event_jSliderRectangleHeightStateChanged

	private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
		this.setVisible(false);
	}//GEN-LAST:event_jButtonOKActionPerformed

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		/* Set the Nimbus look and feel */
		//<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
		/* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
		 * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
		 */
		try {
			for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
				if ("Nimbus".equals(info.getName())) {
					javax.swing.UIManager.setLookAndFeel(info.getClassName());
					break;
				}
			}
		} catch (ClassNotFoundException ex) {
			java.util.logging.Logger.getLogger(CustomizedViewFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (InstantiationException ex) {
			java.util.logging.Logger.getLogger(CustomizedViewFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (IllegalAccessException ex) {
			java.util.logging.Logger.getLogger(CustomizedViewFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (javax.swing.UnsupportedLookAndFeelException ex) {
			java.util.logging.Logger.getLogger(CustomizedViewFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		}
		//</editor-fold>

		/* Create and display the form */
		java.awt.EventQueue.invokeLater(new Runnable() {

			public void run() {
				new CustomizedViewFrame(null).setVisible(true);
			}
		});
	}
	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButtonOK;
	private javax.swing.JCheckBox jCheckBoxShowClient;
	private javax.swing.JLabel jLabelRectangleHeight;
	private javax.swing.JLabel jLabelRectangleShape;
	private javax.swing.JLabel jLabelRectangleWidth;
	private javax.swing.JLabel jLabelResizeShape;
	private javax.swing.JSlider jSliderRectangleHeight;
	private javax.swing.JSlider jSliderRectangleWidth;
	// End of variables declaration//GEN-END:variables
}
