/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ThreadMsgSender
extends Thread {
    private SOAPSender sender = new SOAPSender();
    private MockOperation operation;
    private JLabel image = null;
    private JEditorPane request = null;
    private JEditorPane response = null;
    private String sendTo = null;
    private WSOUIClient client = null;

    public ThreadMsgSender(MockOperation operation, JLabel image, JEditorPane request, JEditorPane response, String sendTo, WSOUIClient client) {
        this.operation = operation;
        this.image = image;
        this.request = request;
        this.response = response;
        this.sendTo = sendTo;
        this.client = client;
    }

    @Override
    public void run() {
        this.image.setIcon(new ImageIcon(WSOUIClient.CLIENT_TEL_IMAGE));
        this.image.paint(this.image.getGraphics());
        MockOperation bop = this.operation;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.request.getText().getBytes());
            Document request = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
            request = this.analyseRequest(request);
            Document response = this.sender.sendSoapRequest(request, this.sendTo, bop.getSoapAction());
            ((InputStream)is).close();
            if (PatternType.IN_OUT.equals((Object)bop.getPattern())) {
                this.response.setText(XMLPrettyPrinter.prettyPrint((Document)response));
            }
            this.image.setIcon(new ImageIcon(WSOUIClient.CLIENT_HAPPY_IMAGE));
            this.image.paint(this.image.getGraphics());
            this.client.getRegistry().refreshConnectionBetweenFramework();
        }
        catch (SOAPException e) {
            this.response.setText(e.getMessage());
            e.printStackTrace();
            this.image.setIcon(new ImageIcon(WSOUIClient.CLIENT_SAD_IMAGE));
            this.image.paint(this.image.getGraphics());
        }
        catch (SAXException e) {
            this.response.setText(e.getMessage());
            e.printStackTrace();
            this.image.setIcon(new ImageIcon(WSOUIClient.CLIENT_SAD_IMAGE));
            this.image.paint(this.image.getGraphics());
        }
        catch (IOException e) {
            this.response.setText(e.getMessage());
            e.printStackTrace();
            this.image.setIcon(new ImageIcon(WSOUIClient.CLIENT_SAD_IMAGE));
            this.image.paint(this.image.getGraphics());
        }
        catch (ParserConfigurationException e) {
            this.response.setText(e.getMessage());
            e.printStackTrace();
            this.image.setIcon(new ImageIcon(WSOUIClient.CLIENT_SAD_IMAGE));
            this.image.paint(this.image.getGraphics());
        }
        catch (WSOUIClientException e) {
            this.response.setText(e.getMessage());
            e.printStackTrace();
            this.image.setIcon(new ImageIcon(WSOUIClient.CLIENT_SAD_IMAGE));
            this.image.paint(this.image.getGraphics());
        }
    }

    private Document analyseRequest(Document request) throws WSOUIClientException {
        Element operation;
        Element body = (Element)request.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
        if (body != null && (operation = DOMUtil.getInstance().getFirstElement(body)) != null && operation.getLocalName().equals("Subscribe")) {
            int ok;
            Element consumerReference = DOMUtil.getInstance().getFirstElement(operation);
            Element addressElmt = DOMUtil.getInstance().getFirstElement(consumerReference);
            String addressString = XMLPrettyPrinter.prettyPrint((Element)addressElmt).replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "").trim();
            String address = (addressString = addressString.substring(addressString.indexOf(">") + 1, addressString.lastIndexOf("<"))).trim();
            if (!this.findIfAddressExist(address) && (ok = JOptionPane.showConfirmDialog(null, "Noticifation server to received notification does not exist.\nDo you want create it?", "Question", 0)) == 0) {
                this.client.addNewNotificationServers(address);
            }
        }
        return request;
    }

    private boolean findIfAddressExist(String address) {
        boolean res = false;
        for (NotificationConsumer_NotifierEndpoint_Server server : this.client.getNotificationServers()) {
            if (!server.getAddress().equals(address)) continue;
            res = true;
            break;
        }
        return res;
    }
}

