/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;

public class ImportNodeFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private WSOUIClient client;
    private Registry registry;
    private boolean monitoring;
    private JButton jButtonOk;
    private JLabel jLabelAdminServiceUrl;
    private JPanel jPanelMain;
    private JTextField jTextFieldAdminServiceUrl;

    public ImportNodeFrame(WSOUIClient client, boolean monitoring) {
        this.initComponents();
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.monitoring = monitoring;
        if (this.monitoring) {
            this.setTitle("Import Monitoring");
        } else {
            this.setTitle("Import Node");
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
        this.client = client;
        this.registry = client.getRegistry();
        this.setLocation();
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabelAdminServiceUrl = new JLabel();
        this.jTextFieldAdminServiceUrl = new JTextField();
        this.jButtonOk = new JButton();
        this.jLabelAdminServiceUrl.setText("Add administration service URL of node to import:");
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportNodeFrame.this.jButtonOkActionPerformed(evt);
            }
        });
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldAdminServiceUrl, -1, 615, Short.MAX_VALUE).addComponent(this.jLabelAdminServiceUrl).addComponent(this.jButtonOk, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelAdminServiceUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAdminServiceUrl, -2, -1, -2).addGap(29, 29, 29).addComponent(this.jButtonOk).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        try {
            String adminUrl = this.jTextFieldAdminServiceUrl.getText();
            if (!adminUrl.endsWith("?wsdl")) {
                adminUrl = adminUrl + "?wsdl";
            }
            Node node = this.registry.addNewAdminWsdlofESBNode(new URL(adminUrl));
            node.setMonitoringNode(this.monitoring);
            this.client.getTopology().refresh();
            this.setVisible(false);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Import node Interrupted", 0);
        }
        catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Import node Interrupted", 0);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ImportNodeFrame(null, false).setVisible(true);
            }
        });
    }
}

