/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.petalslink.easiestdemo.client.model.impl.ws;

import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.easiestdemo.client.Constants;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;

/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class MockOperationImpl implements MockOperation {

	private BindingOperation bop;

	private MockBinding b;

	private String soapAction;

	private String request;

	private PatternType pattern;

	private static int cpt = 0;

	public MockOperationImpl(MockBinding b, BindingOperation bop) throws SOAPException  {
		this.b = b;
		this.bop = bop;

		if(this.bop.getBindingOperationOutput() == null){
			this.pattern = PatternType.IN_ONLY;
		}else{
			this.pattern = PatternType.IN_OUT;
		}

		this.soapAction = "\"" + SoapBindingHelper.getSoapOperation((com.ebmwebsourcing.easywsdl11.api.element.BindingOperation) bop.getModel()).getSoapAction() + "\"";

		if(this.bop != null && this.bop.findOperation() != null && this.bop.findOperation().getInput() != null && 
				this.bop.findOperation().getInput().getElement() != null && 
				this.bop.findOperation().getInput().getElement().inferQName() != null &&
				this.bop.findOperation().getInput().getElement().inferQName().equals(Constants.WS_SUBSCRIBE_ELEMENT)) {
			this.request = generateSubscribeRequest();
		} else {
			this.request = this.printRequest();
		}
	}

	private String generateSubscribeRequest() {
		// TODO: generate request from WS-notif easyboxed when it will exist
		String res = "" +
				"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" + 
				"<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\">\r\n" + 
				"  <soap-env:Body>\r\n" +
				"    <wsn:Subscribe xmlns:add=\"http://www.w3.org/2005/08/addressing\" xmlns:wsn=\"http://docs.oasis-open.org/wsn/b-2\" targetnamespace=\"http://docs.oasis-open.org/wsn/b-2\">\r\n" + 
				"      <wsn:ConsumerReference>\r\n" + 
				"        <add:Address>" + generateNotificationServerAddress() + "</add:Address>\r\n" + 
				"      </wsn:ConsumerReference>\r\n";

		if(this.getBinding().getEndpoint().getName().toLowerCase().contains("wsdm")) {
			res = res + 
					"      <wsn:Filter>\r\n" + 
					"        <wsn:TopicExpression Dialect=\"http://www.w3.org/TR/1999/REC-xpath-19991116\"\r\n" + 
					"					xmlns:mows-ev=\"http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml\">\r\n" + 
					"					mows-ev:MetricsCapability\r\n" + 
					"		 </wsn:TopicExpression>\r\n" + 
					"      </wsn:Filter>\r\n"; 
		} else {
			res = res + 
					"      <wsn:Filter>\r\n" + 
					"        <!-- No filter: I subscribe for all events provided by this Event producer -->\r\n" +
					"      </wsn:Filter>\r\n"; 
		}
		res = res + "    </wsn:Subscribe>\r\n" +
				"  </soap-env:Body>\r\n" + 
				"</soap-env:Envelope>\r\n";
		return res;
	}

	private String generateNotificationServerAddress() {
		String port = String.valueOf(9800 + cpt);
		cpt++;
		String res = "http://localhost:" + port + "/" + this.b.getEndpoint().getName();
		return res;
	}

	public MockBinding getBinding() {
		return this.b;
	}

	public String getName() {
		return this.bop.getName();
	}


	public String printRequest() throws SOAPException  {
		Document doc = this.b.getEndpoint().getService().getSOAPMessageGenerator().generateSoapRequest(bop);

		return XMLPrettyPrinter.prettyPrint(doc);
	}

	@Override
	public String getRequest() {
		return this.request;
	}


	@Override
	public String getSoapAction() {
		return this.soapAction;
	}

	@Override
	public void setRequest(String req) {
		this.request = req;
	}

	public String toString() {
		return this.getName();
	}

	@Override
	public PatternType getPattern() {
		return this.pattern;
	}

	@Override
	public void setPattern(PatternType pattern) {
		this.pattern = pattern;

	}


}
